/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.serveroperations.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum ServerActiveStatus {
    UNKNOWN(0, "Unknown", "The state of the server is unknown.  This is equivalent to a null value."),
    STARTING(1, "Starting", "The server is starting."),
    RUNNING(2, "Running", "The server has completed start up and is running."),
    STOPPING(3, "Stopping", "The server has received a request to shut down."),
    INACTIVE(99, "Inactive", "The server is not running.");

    private final int ordinal;
    private final String name;
    private final String description;

    private ServerActiveStatus(int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ServerActiveStatus{ordinal=" + this.ordinal + ", name='" + this.name + "', description='" + this.description + "'}";
    }
}

