/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.datamanager.api.ConnectionManagerInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.EmbeddedConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.EndpointRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.EndpointResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.EndpointsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ConnectionElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.EndpointElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.ConnectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.EndpointProperties;

public class ConnectionManagerClient
implements ConnectionManagerInterface {
    private static final String connectionURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connections";
    private static final String connectorTypeURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connector-types";
    private static final String endpointURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/endpoints";
    private static final String assetURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/assets";
    String serverName;
    String serverPlatformURLRoot;
    AuditLog auditLog = null;
    InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    DataManagerRESTClient restClient;

    public ConnectionManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public ConnectionManagerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot);
    }

    public ConnectionManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public ConnectionManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public ConnectionManagerClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    @Override
    public String createConnection(String userId, String dataManagerGUID, String dataManagerName, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnection";
        String propertiesParameterName = "connectionDetails";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createConnection");
        this.invalidParameterHandler.validateObject(connectionProperties, "connectionDetails", "createConnection");
        this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "qualifiedName", "createConnection");
        String urlTemplate = this.serverPlatformURLRoot + connectionURLTemplatePrefix;
        ConnectionRequestBody requestBody = new ConnectionRequestBody(connectionProperties);
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnection", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    @Override
    public String createConnectionFromTemplate(String userId, String dataManagerGUID, String dataManagerName, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectionFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createConnectionFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createConnectionFromTemplate");
        this.invalidParameterHandler.validateObject(templateProperties, "templateProperties", "createConnectionFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createConnectionFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connections/from-template/{2}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnectionFromTemplate", urlTemplate, requestBody, this.serverName, userId, templateGUID);
        return restResult.getGUID();
    }

    @Override
    public void updateConnection(String userId, String dataManagerGUID, String dataManagerName, String connectionGUID, boolean isMergeUpdate, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnection";
        String elementGUIDParameterName = "connectionGUID";
        String propertiesParameterName = "connectionDetails";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "updateConnection");
        this.invalidParameterHandler.validateObject(connectionProperties, "connectionDetails", "updateConnection");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "qualifiedName", "updateConnection");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connections/{2}?isMergeUpdate={3}";
        ConnectionRequestBody requestBody = new ConnectionRequestBody(connectionProperties);
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        this.restClient.callVoidPostRESTCall("updateConnection", urlTemplate, requestBody, this.serverName, userId, connectionGUID, isMergeUpdate);
    }

    @Override
    public void setupConnectorType(String userId, String dataManagerGUID, String dataManagerName, String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupConnectorType");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "setupConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connections/{2}/connector-types/{3}";
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        this.restClient.callVoidPostRESTCall("setupConnectorType", urlTemplate, requestBody, this.serverName, userId, connectionGUID, connectorTypeGUID);
    }

    @Override
    public void clearConnectorType(String userId, String dataManagerGUID, String dataManagerName, String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearConnectorType");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "clearConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connections/{2}/connector-types/{3}/delete";
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        this.restClient.callVoidPostRESTCall("clearConnectorType", urlTemplate, requestBody, this.serverName, userId, connectionGUID, connectorTypeGUID);
    }

    @Override
    public void setupEndpoint(String userId, String dataManagerGUID, String dataManagerName, String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupEndpoint");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "setupEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connections/{2}/endpoints/{3}";
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        this.restClient.callVoidPostRESTCall("setupEndpoint", urlTemplate, requestBody, this.serverName, userId, connectionGUID, endpointGUID);
    }

    @Override
    public void clearEndpoint(String userId, String dataManagerGUID, String dataManagerName, String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearEndpoint");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "clearEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connections/{2}/endpoints/{3}/delete";
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        this.restClient.callVoidPostRESTCall("clearEndpoint", urlTemplate, requestBody, this.serverName, userId, connectionGUID, endpointGUID);
    }

    @Override
    public void setupEmbeddedConnection(String userId, String dataManagerGUID, String dataManagerName, String connectionGUID, int position, String displayName, Map<String, Object> arguments, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", "setupEmbeddedConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connections/{2}/embedded-connections/{3}";
        EmbeddedConnectionRequestBody requestBody = new EmbeddedConnectionRequestBody();
        requestBody.setPosition(position);
        requestBody.setDisplayName(displayName);
        requestBody.setArguments(arguments);
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        this.restClient.callVoidPostRESTCall("setupEmbeddedConnection", urlTemplate, requestBody, this.serverName, userId, connectionGUID, embeddedConnectionGUID);
    }

    @Override
    public void clearEmbeddedConnection(String userId, String dataManagerGUID, String dataManagerName, String connectionGUID, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", "clearEmbeddedConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connections/{2}/embedded-connections/{3}/delete}";
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        this.restClient.callVoidPostRESTCall("clearEmbeddedConnection", urlTemplate, requestBody, this.serverName, userId, connectionGUID, embeddedConnectionGUID);
    }

    @Override
    public void setupAssetConnection(String userId, String dataManagerGUID, String dataManagerName, String assetGUID, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAssetConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupAssetConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupAssetConnection");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "setupAssetConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/assets/{2}/connections/{3}";
        AssetConnectionRequestBody requestBody = new AssetConnectionRequestBody();
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        this.restClient.callVoidPostRESTCall("setupAssetConnection", urlTemplate, requestBody, this.serverName, userId, assetGUID, connectionGUID);
    }

    @Override
    public void clearAssetConnection(String userId, String dataManagerGUID, String dataManagerName, String assetGUID, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearAssetConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearAssetConnection");
        this.invalidParameterHandler.validateGUID(assetGUID, "embeddedConnectionGUID", "clearAssetConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/assets/{2}/connections/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        this.restClient.callVoidPostRESTCall("clearAssetConnection", urlTemplate, requestBody, this.serverName, userId, assetGUID, connectionGUID);
    }

    @Override
    public void removeConnection(String userId, String dataManagerGUID, String dataManagerName, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnection";
        String elementGUIDParameterName = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "removeConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connections/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        this.restClient.callVoidPostRESTCall("removeConnection", urlTemplate, requestBody, this.serverName, userId, connectionGUID);
    }

    @Override
    public List<ConnectionElement> findConnections(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findConnection";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findConnection");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findConnection");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connections/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ConnectionsResponse restResult = this.restClient.callConnectionsPostRESTCall("findConnection", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public List<ConnectionElement> getConnectionsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionByName");
        this.invalidParameterHandler.validateName(name, "name", "getConnectionByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectionByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connections/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        ConnectionsResponse restResult = this.restClient.callConnectionsPostRESTCall("getConnectionByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public ConnectionElement getConnectionByGUID(String userId, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionByGUID";
        String guidParameterName = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionByGUID");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getConnectionByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connections/{2}";
        ConnectionResponse restResult = this.restClient.callConnectionGetRESTCall("getConnectionByGUID", urlTemplate, this.serverName, userId, connectionGUID);
        return restResult.getElement();
    }

    @Override
    public String createEndpoint(String userId, String dataManagerGUID, String dataManagerName, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createPrimitiveEndpoint";
        String propertiesParameterName = "endpointProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createPrimitiveEndpoint");
        this.invalidParameterHandler.validateObject(endpointProperties, "endpointProperties", "createPrimitiveEndpoint");
        this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "qualifiedName", "createPrimitiveEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + endpointURLTemplatePrefix;
        EndpointRequestBody requestBody = new EndpointRequestBody(endpointProperties);
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createPrimitiveEndpoint", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    @Override
    public String createEndpointFromTemplate(String userId, String dataManagerGUID, String dataManagerName, String networkAddress, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpointFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        String networkAddressParameterName = "networkAddress";
        this.invalidParameterHandler.validateUserId(userId, "createEndpointFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createEndpointFromTemplate");
        this.invalidParameterHandler.validateObject(templateProperties, "templateProperties", "createEndpointFromTemplate");
        this.invalidParameterHandler.validateName(networkAddress, "networkAddress", "createEndpointFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createEndpointFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/endpoints/network-address/{2}/from-template/{3}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEndpointFromTemplate", urlTemplate, requestBody, this.serverName, userId, networkAddress, templateGUID);
        return restResult.getGUID();
    }

    @Override
    public void updateEndpoint(String userId, String dataManagerGUID, String dataManagerName, boolean isMergeUpdate, String endpointGUID, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEndpoint";
        String elementGUIDParameterName = "endpointGUID";
        String propertiesParameterName = "endpointProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "updateEndpoint");
        this.invalidParameterHandler.validateObject(endpointProperties, "endpointProperties", "updateEndpoint");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "qualifiedName", "updateEndpoint");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/endpoints/{2}?isMergeUpdate={3}";
        EndpointRequestBody requestBody = new EndpointRequestBody(endpointProperties);
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        this.restClient.callVoidPostRESTCall("updateEndpoint", urlTemplate, requestBody, this.serverName, userId, endpointGUID, isMergeUpdate);
    }

    @Override
    public void removeEndpoint(String userId, String dataManagerGUID, String dataManagerName, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeEndpoint";
        String elementGUIDParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "removeEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/endpoints/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(dataManagerGUID);
        requestBody.setExternalSourceName(dataManagerName);
        this.restClient.callVoidPostRESTCall("removeEndpoint", urlTemplate, requestBody, this.serverName, userId, endpointGUID);
    }

    @Override
    public List<EndpointElement> findEndpoints(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findEndpoints";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findEndpoints");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findEndpoints");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findEndpoints");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/endpoints/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        EndpointsResponse restResult = this.restClient.callEndpointsPostRESTCall("findEndpoints", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public List<EndpointElement> getEndpointsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointsByName");
        this.invalidParameterHandler.validateName(name, "name", "getEndpointsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getEndpointsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/endpoints/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        EndpointsResponse restResult = this.restClient.callEndpointsPostRESTCall("getEndpointsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public EndpointElement getEndpointByGUID(String userId, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointByGUID";
        String guidParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointByGUID");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "getEndpointByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/endpoints/{2}";
        EndpointResponse restResult = this.restClient.callEndpointGetRESTCall("getEndpointByGUID", urlTemplate, this.serverName, userId, endpointGUID);
        return restResult.getElement();
    }

    @Override
    public List<ConnectorTypeElement> findConnectorTypes(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findConnectorType";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findConnectorType");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findConnectorType");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connector-types/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ConnectorTypesResponse restResult = this.restClient.callConnectorTypesPostRESTCall("findConnectorType", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public List<ConnectorTypeElement> getConnectorTypesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypeByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypeByName");
        this.invalidParameterHandler.validateName(name, "name", "getConnectorTypeByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectorTypeByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connector-types/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        ConnectorTypesResponse restResult = this.restClient.callConnectorTypesPostRESTCall("getConnectorTypeByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public ConnectorTypeElement getConnectorTypeByGUID(String userId, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypeByGUID";
        String guidParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypeByGUID");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "getConnectorTypeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/connector-types/{2}";
        ConnectorTypeResponse restResult = this.restClient.callConnectorTypeGetRESTCall("getConnectorTypeByGUID", urlTemplate, this.serverName, userId, connectorTypeGUID);
        return restResult.getElement();
    }
}

