/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ClassificationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;

public class DataManagerBaseClient {
    final String serverName;
    final String serverPlatformURLRoot;
    final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    final DataManagerRESTClient restClient;

    public DataManagerBaseClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public DataManagerBaseClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot);
    }

    public DataManagerBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public DataManagerBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public DataManagerBaseClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor (with REST client)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor (with REST client)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    String createReferenceable(String userId, String externalSourceGUID, String externalSourceName, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject(properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    String createReferenceableFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, TemplateProperties templateProperties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject(templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", methodName);
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, templateGUID);
        return restResult.getGUID();
    }

    String createReferenceableFromTemplateWithParent(String userId, String externalSourceGUID, String externalSourceName, String parentGUID, String parentGUIDParameterName, String templateGUID, TemplateProperties templateProperties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateGUID(parentGUID, parentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject(templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", methodName);
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setParentGUID(parentGUID);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, templateGUID);
        return restResult.getGUID();
    }

    String createReferenceableWithParent(String userId, String externalSourceGUID, String externalSourceName, String parentGUID, String parentGUIDParameterName, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentGUID, parentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject(properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setParentGUID(parentGUID);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    void updateReferenceable(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, boolean isMergeUpdate, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject(properties, propertiesParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        }
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, elementGUID, isMergeUpdate);
    }

    void setReferenceableClassification(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameter, ClassificationProperties properties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ClassificationRequestBody requestBody = new ClassificationRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, elementGUID);
    }

    void removeReferenceableClassification(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameter, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, elementGUID);
    }

    void setupRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, primaryElementGUID, secondaryElementGUID);
    }

    void setupRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, String relationshipTypeName, String relationshipTypeNameParameterName, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, relationshipTypeNameParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, primaryElementGUID, relationshipTypeName, secondaryElementGUID);
    }

    void clearRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, primaryElementGUID, secondaryElementGUID);
    }

    void clearRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, String relationshipTypeName, String relationshipTypeNameParameterName, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, relationshipTypeNameParameterName, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, primaryElementGUID, relationshipTypeName, secondaryElementGUID);
    }

    List<RelatedElementStub> getRelatedElements(String userId, String startingElementGUID, String startingElementGUIDParameterName, String urlTemplate, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingElementGUIDParameterName, methodName);
        RelatedElementsResponse restResult = this.restClient.callRelatedElementsGetRESTCall(methodName, urlTemplate, this.serverName, userId, startingElementGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public void removeReferenceable(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, elementGUID);
    }

    public void removeReferenceable(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String urlTemplate, boolean cascadedDeleteOption, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, elementGUID, cascadedDeleteOption);
    }
}

