/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventInterface;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.connectors.outtopic.DataManagerOutTopicClientConnector;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.ffdc.OMAGOCFErrorCode;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.ConnectionResponse;

public class DataManagerEventClient
implements DataManagerEventInterface {
    private static final String serviceName = "Data Manager OMAS";
    private final String serverName;
    private final String serverPlatformURLRoot;
    private final String callerId;
    private final OCFRESTClient restClient;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private DataManagerOutTopicClientConnector configurationEventTopicConnector = null;
    private AuditLog auditLog = null;

    public DataManagerEventClient(String serverName, String serverPlatformURLRoot, String callerId) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new OCFRESTClient(serverName, serverPlatformURLRoot);
        this.callerId = callerId;
    }

    public DataManagerEventClient(String serverName, String serverPlatformURLRoot, String userId, String password, String callerId) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new OCFRESTClient(serverName, serverPlatformURLRoot, userId, password);
        this.callerId = callerId;
    }

    public DataManagerEventClient(String serverName, String serverPlatformURLRoot, OCFRESTClient restClient, int maxPageSize, AuditLog auditLog, String callerId) throws InvalidParameterException {
        String methodName = "Constructor (with REST Client)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with REST Client)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
        this.auditLog = auditLog;
        this.callerId = callerId;
    }

    public String getConfigurationServerName() {
        return this.serverName;
    }

    @Override
    public void registerListener(String userId, DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "registerListener";
        String nameParameter = "listener";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/out-topic-connection/{2}";
        this.invalidParameterHandler.validateUserId(userId, "registerListener");
        this.invalidParameterHandler.validateObject(listener, "listener", "registerListener");
        if (this.configurationEventTopicConnector == null) {
            ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
            ConnectionResponse restResult = this.restClient.callOCFConnectionGetRESTCall("registerListener", urlTemplate, this.serverName, userId, this.callerId);
            Connection topicConnection = restResult.getConnection();
            Connector connector = connectorBroker.getConnector(topicConnection);
            if (connector == null) {
                throw new ConnectorCheckedException(OMAGOCFErrorCode.NULL_CONNECTOR_RETURNED.getMessageDefinition(topicConnection.getQualifiedName(), serviceName, this.serverName, this.serverPlatformURLRoot), this.getClass().getName(), "registerListener");
            }
            if (connector instanceof DataManagerOutTopicClientConnector) {
                this.configurationEventTopicConnector = (DataManagerOutTopicClientConnector)connector;
                this.configurationEventTopicConnector.start();
            } else {
                throw new ConnectorCheckedException(OMAGOCFErrorCode.WRONG_TYPE_OF_CONNECTOR.getMessageDefinition(topicConnection.getQualifiedName(), serviceName, this.serverName, this.serverPlatformURLRoot, DataManagerOutTopicClientConnector.class.getName()), this.getClass().getName(), "registerListener");
            }
        }
        this.configurationEventTopicConnector.registerListener(userId, listener);
    }
}

