/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.DatabaseManagerInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerBaseClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.commonservices.ffdc.rest.DatabaseColumnResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DatabaseColumnsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DatabaseResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DatabaseSchemaResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DatabaseSchemasResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DatabaseTableResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DatabaseTablesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DatabaseViewResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DatabaseViewsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DatabasesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DatabaseElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DatabaseTableElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DatabaseViewElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.databases.DatabaseProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.databases.DatabaseSchemaProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.databases.DatabaseColumnProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.databases.DatabaseForeignKeyProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.databases.DatabasePrimaryKeyProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.databases.DatabaseSchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.databases.DatabaseTableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.databases.DatabaseViewProperties;

public class DatabaseManagerClient
extends DataManagerBaseClient
implements DatabaseManagerInterface {
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases";

    public DatabaseManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public DatabaseManagerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public DatabaseManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public DatabaseManagerClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public DatabaseManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    @Override
    public String createDatabase(String userId, String databaseManagerGUID, String databaseManagerName, DatabaseProperties databaseProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabase";
        String propertiesParameterName = "databaseProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases";
        return super.createReferenceable(userId, databaseManagerGUID, databaseManagerName, databaseProperties, "databaseProperties", urlTemplate, "createDatabase");
    }

    @Override
    public String createDatabaseFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseFromTemplate";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/from-template/{2}";
        return super.createReferenceableFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, templateProperties, urlTemplate, "createDatabaseFromTemplate");
    }

    @Override
    public void updateDatabase(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, boolean isMergeUpdate, DatabaseProperties databaseProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDatabase";
        String elementGUIDParameterName = "databaseGUID";
        String propertiesParameterName = "databaseProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/{2}";
        super.updateReferenceable(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", isMergeUpdate, databaseProperties, "databaseProperties", urlTemplate, "updateDatabase");
    }

    @Override
    public void publishDatabase(String userId, String databaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishDatabase";
        String elementGUIDParameterName = "databaseGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/{2}/publish";
        super.setReferenceableClassification(userId, null, null, databaseGUID, "databaseGUID", null, urlTemplate, "publishDatabase");
    }

    @Override
    public void withdrawDatabase(String userId, String databaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawDatabase";
        String elementGUIDParameterName = "databaseGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databasesdatabases/{2}/withdraw";
        super.setReferenceableClassification(userId, null, null, databaseGUID, "databaseGUID", null, urlTemplate, "withdrawDatabase");
    }

    @Override
    public void removeDatabase(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, boolean cascadedDelete) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDatabase";
        String elementGUIDParameterName = "databaseGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/{2}/delete?cascadedDelete={3}";
        super.removeReferenceable(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", urlTemplate, cascadedDelete, "removeDatabase");
    }

    @Override
    public List<DatabaseElement> findDatabases(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDatabases";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDatabases");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDatabases");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDatabases");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        DatabasesResponse restResult = this.restClient.callDatabasesPostRESTCall("findDatabases", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public List<DatabaseElement> getDatabasesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabasesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDatabasesByName");
        this.invalidParameterHandler.validateName(name, "name", "getDatabasesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDatabasesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        DatabasesResponse restResult = this.restClient.callDatabasesPostRESTCall("getDatabasesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public List<DatabaseElement> getDatabasesForDatabaseManager(String userId, String databaseManagerGUID, String databaseManagerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabasesForDatabaseManager";
        String databaseManagerGUIDParameterName = "databaseManagerGUID";
        String databaseManagerNameParameterName = "databaseManagerName";
        this.invalidParameterHandler.validateUserId(userId, "getDatabasesForDatabaseManager");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "getDatabasesForDatabaseManager");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "getDatabasesForDatabaseManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDatabasesForDatabaseManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/by-database-manager?startFrom={2}&pageSize={3}";
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(databaseManagerGUID);
        requestBody.setExternalSourceName(databaseManagerName);
        DatabasesResponse restResult = this.restClient.callDatabasesPostRESTCall("getDatabasesForDatabaseManager", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public DatabaseElement getDatabaseByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDatabaseByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/{2}";
        DatabaseResponse restResult = this.restClient.callDatabaseGetRESTCall("getDatabaseByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    @Override
    public String createDatabaseSchema(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, DatabaseSchemaProperties databaseSchemaProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseSchema";
        String parentElementGUIDParameterName = "databaseGUID";
        String propertiesParameterName = "databaseSchemaProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas";
        return super.createReferenceableWithParent(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", databaseSchemaProperties, "databaseSchemaProperties", urlTemplate, "createDatabaseSchema");
    }

    @Override
    public String createDatabaseSchemaFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseSchemaFromTemplate";
        String parentElementGUIDParameterName = "databaseGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/from-template/{2}";
        return super.createReferenceableFromTemplateWithParent(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", templateGUID, templateProperties, urlTemplate, "createDatabaseSchemaFromTemplate");
    }

    @Override
    public void updateDatabaseSchema(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, boolean isMergeUpdate, DatabaseSchemaProperties databaseSchemaProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDatabaseSchema";
        String elementGUIDParameterName = "databaseSchemaGUID";
        String propertiesParameterName = "databaseProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/{2}";
        super.updateReferenceable(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, "databaseSchemaGUID", isMergeUpdate, databaseSchemaProperties, "databaseProperties", urlTemplate, "updateDatabaseSchema");
    }

    @Override
    public void publishDatabaseSchema(String userId, String databaseSchemaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishDatabaseSchema";
        String elementGUIDParameterName = "databaseSchemaGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/{2}/publish";
        super.setReferenceableClassification(userId, null, null, databaseSchemaGUID, "databaseSchemaGUID", null, urlTemplate, "publishDatabaseSchema");
    }

    @Override
    public void withdrawDatabaseSchema(String userId, String databaseSchemaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawDatabase";
        String elementGUIDParameterName = "databaseSchemaGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/{2}/withdraw";
        super.setReferenceableClassification(userId, null, null, databaseSchemaGUID, "databaseSchemaGUID", null, urlTemplate, "withdrawDatabase");
    }

    @Override
    public void removeDatabaseSchema(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, boolean cascadedDelete) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDatabaseSchema";
        String elementGUIDParameterName = "databaseSchemaGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/{2}/delete?cascadedDelete={3}";
        super.removeReferenceable(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, "databaseSchemaGUID", urlTemplate, cascadedDelete, "removeDatabaseSchema");
    }

    @Override
    public List<DatabaseSchemaElement> findDatabaseSchemas(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDatabaseSchemas";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDatabaseSchemas");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDatabaseSchemas");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDatabaseSchemas");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        DatabaseSchemasResponse restResult = this.restClient.callDatabaseSchemasPostRESTCall("findDatabaseSchemas", urlTemplate, requestBody, this.serverName, userId, searchString, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public List<DatabaseSchemaElement> getSchemasForDatabase(String userId, String databaseGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemasForDatabase";
        String parentElementGUIDParameterName = "databaseGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemasForDatabase");
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", "getSchemasForDatabase");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSchemasForDatabase");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/{2}/schemas?startFrom={3}&pageSize={4}";
        DatabaseSchemasResponse restResult = this.restClient.callDatabaseSchemasGetRESTCall("getSchemasForDatabase", urlTemplate, this.serverName, userId, databaseGUID, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public List<DatabaseSchemaElement> getDatabaseSchemasByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseSchemasByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseSchemasByName");
        this.invalidParameterHandler.validateName(name, "name", "getDatabaseSchemasByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDatabaseSchemasByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        DatabaseSchemasResponse restResult = this.restClient.callDatabaseSchemasPostRESTCall("getDatabaseSchemasByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public DatabaseSchemaElement getDatabaseSchemaByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseSchemaByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseSchemaByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDatabaseSchemaByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/{2}";
        DatabaseSchemaResponse restResult = this.restClient.callDatabaseSchemaGetRESTCall("getDatabaseSchemaByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    @Override
    public String createDatabaseSchemaType(String userId, String databaseManagerGUID, String databaseManagerName, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseSchemaType";
        String qualifiedNameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schema-type";
        DatabaseSchemaTypeProperties databaseSchemaTypeProperties = new DatabaseSchemaTypeProperties();
        databaseSchemaTypeProperties.setQualifiedName(qualifiedName);
        return super.createReferenceable(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeProperties, "qualifiedName", urlTemplate, "createDatabaseSchemaType");
    }

    @Override
    public void attachSchemaTypeToDatabaseAsset(String userId, String databaseManagerGUID, String databaseManagerName, String databaseAssetGUID, String schemaTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "attachSchemaTypeToDatabaseAsset";
        String databaseAssetGUIDParameterName = "databaseAssetGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/{2}/schema-type/{3}";
        super.setupRelationship(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, "databaseAssetGUID", null, schemaTypeGUID, "schemaTypeGUID", urlTemplate, "attachSchemaTypeToDatabaseAsset");
    }

    @Override
    public String createDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseAssetGUID, DatabaseTableProperties databaseTableProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseTable";
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String propertiesParameterName = "databaseTableProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables";
        return super.createReferenceableWithParent(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, "databaseAssetGUID", databaseTableProperties, "databaseTableProperties", urlTemplate, "createDatabaseTable");
    }

    @Override
    public String createDatabaseTableFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseAssetGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseTableFromTemplate";
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/from-template/{2}";
        return super.createReferenceableFromTemplateWithParent(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, "databaseAssetGUID", templateGUID, templateProperties, urlTemplate, "createDatabaseTableFromTemplate");
    }

    @Override
    public String createDatabaseTableForSchemaType(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaTypeGUID, DatabaseTableProperties databaseTableProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseTableForSchemaType";
        String parentElementGUIDParameterName = "databaseSchemaTypeGUID";
        String propertiesParameterName = "databaseTableProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schema-type/tables";
        return super.createReferenceableWithParent(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", databaseTableProperties, "databaseTableProperties", urlTemplate, "createDatabaseTableForSchemaType");
    }

    @Override
    public void updateDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, boolean isMergeUpdate, DatabaseTableProperties databaseTableProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDatabaseTable";
        String elementGUIDParameterName = "databaseTableGUID";
        String propertiesParameterName = "databaseTableProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/{2}";
        super.updateReferenceable(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, "databaseTableGUID", isMergeUpdate, databaseTableProperties, "databaseTableProperties", urlTemplate, "updateDatabaseTable");
    }

    @Override
    public void removeDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, boolean cascadedDelete) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDatabaseTable";
        String elementGUIDParameterName = "databaseTableGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/{2}/delete?cascadedDelete={3}";
        super.removeReferenceable(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, "databaseTableGUID", urlTemplate, cascadedDelete, "removeDatabaseTable");
    }

    @Override
    public List<DatabaseTableElement> findDatabaseTables(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDatabaseTables";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDatabaseTables");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDatabaseTables");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDatabaseTables");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        DatabaseTablesResponse restResult = this.restClient.callDatabaseTablesPostRESTCall("findDatabaseTables", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    @Deprecated
    public List<DatabaseTableElement> getTablesForDatabaseSchema(String userId, String databaseSchemaGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getTablesForDatabaseAsset(userId, databaseSchemaGUID, startFrom, pageSize);
    }

    @Override
    public List<DatabaseTableElement> getTablesForDatabaseAsset(String userId, String databaseAssetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTablesForDatabaseAsset";
        String parentElementGUIDParameterName = "databaseAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getTablesForDatabaseAsset");
        this.invalidParameterHandler.validateGUID(databaseAssetGUID, "databaseAssetGUID", "getTablesForDatabaseAsset");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTablesForDatabaseAsset");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/{2}/tables?startFrom={3}&pageSize={4}";
        DatabaseTablesResponse restResult = this.restClient.callDatabaseTablesGetRESTCall("getTablesForDatabaseAsset", urlTemplate, this.serverName, userId, databaseAssetGUID, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public List<DatabaseTableElement> getDatabaseTablesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseTablesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseTablesByName");
        this.invalidParameterHandler.validateName(name, "name", "getDatabaseTablesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDatabaseTablesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        DatabaseTablesResponse restResult = this.restClient.callDatabaseTablesPostRESTCall("getDatabaseTablesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public DatabaseTableElement getDatabaseTableByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseTableByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseTableByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDatabaseTableByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/{2}";
        DatabaseTableResponse restResult = this.restClient.callDatabaseTableGetRESTCall("getDatabaseTableByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    @Override
    public String createDatabaseView(String userId, String databaseManagerGUID, String databaseManagerName, String databaseAssetGUID, DatabaseViewProperties databaseViewProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseView";
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String propertiesParameterName = "databaseViewProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/views";
        return super.createReferenceableWithParent(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, "databaseAssetGUID", databaseViewProperties, "databaseViewProperties", urlTemplate, "createDatabaseView");
    }

    @Override
    public String createDatabaseViewFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseAssetGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseViewFromTemplate";
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/views/from-template/{2}";
        return super.createReferenceableFromTemplateWithParent(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, "databaseAssetGUID", templateGUID, templateProperties, urlTemplate, "createDatabaseViewFromTemplate");
    }

    @Override
    public String createDatabaseViewForSchemaType(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaTypeGUID, DatabaseViewProperties databaseViewProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseViewForSchemaType";
        String parentElementGUIDParameterName = "databaseSchemaTypeGUID";
        String propertiesParameterName = "databaseViewProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schema-type/tables/views";
        return super.createReferenceableWithParent(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", databaseViewProperties, "databaseViewProperties", urlTemplate, "createDatabaseViewForSchemaType");
    }

    @Override
    public void updateDatabaseView(String userId, String databaseManagerGUID, String databaseManagerName, String databaseViewGUID, boolean isMergeUpdate, DatabaseViewProperties databaseViewProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDatabaseView";
        String elementGUIDParameterName = "databaseViewGUID";
        String propertiesParameterName = "databaseViewProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/views/{2}";
        super.updateReferenceable(userId, databaseManagerGUID, databaseManagerName, databaseViewGUID, "databaseViewGUID", isMergeUpdate, databaseViewProperties, "databaseViewProperties", urlTemplate, "updateDatabaseView");
    }

    @Override
    public void removeDatabaseView(String userId, String databaseManagerGUID, String databaseManagerName, String databaseViewGUID, boolean cascadedDelete) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDatabaseView";
        String elementGUIDParameterName = "databaseViewGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/views/{2}/delete?cascadedDelete={3}";
        super.removeReferenceable(userId, databaseManagerGUID, databaseManagerName, databaseViewGUID, "databaseViewGUID", urlTemplate, cascadedDelete, "removeDatabaseView");
    }

    @Override
    public List<DatabaseViewElement> findDatabaseViews(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDatabaseViews";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDatabaseViews");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDatabaseViews");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDatabaseViews");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/views/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        DatabaseViewsResponse restResult = this.restClient.callDatabaseViewsPostRESTCall("findDatabaseViews", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    @Deprecated
    public List<DatabaseViewElement> getViewsForDatabaseSchema(String userId, String databaseSchemaGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getViewsForDatabaseAsset(userId, databaseSchemaGUID, startFrom, pageSize);
    }

    @Override
    public List<DatabaseViewElement> getViewsForDatabaseAsset(String userId, String databaseAssetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getViewsForDatabaseAsset";
        String parentElementGUIDParameterName = "databaseAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getViewsForDatabaseAsset");
        this.invalidParameterHandler.validateGUID(databaseAssetGUID, "databaseAssetGUID", "getViewsForDatabaseAsset");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getViewsForDatabaseAsset");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/{2}/tables/views?startFrom={3}&pageSize={4}";
        DatabaseViewsResponse restResult = this.restClient.callDatabaseViewsGetRESTCall("getViewsForDatabaseAsset", urlTemplate, this.serverName, userId, databaseAssetGUID, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public List<DatabaseViewElement> getDatabaseViewsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseViewsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseViewsByName");
        this.invalidParameterHandler.validateName(name, "name", "getDatabaseViewsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDatabaseViewsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/views/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        DatabaseViewsResponse restResult = this.restClient.callDatabaseViewsPostRESTCall("getDatabaseViewsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public DatabaseViewElement getDatabaseViewByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseViewByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseViewByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDatabaseViewByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/views/{2}";
        DatabaseViewResponse restResult = this.restClient.callDatabaseViewGetRESTCall("getDatabaseViewByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    @Override
    public String createDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, DatabaseColumnProperties databaseColumnProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseColumn";
        String parentElementGUIDParameterName = "databaseTableGUID";
        String propertiesParameterName = "databaseColumnProperties";
        String dataTypeParameterName = "databaseColumnProperties.dataType";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseColumn");
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", "createDatabaseColumn");
        this.invalidParameterHandler.validateObject(databaseColumnProperties, "databaseColumnProperties", "createDatabaseColumn");
        if (databaseColumnProperties.getExternalTypeGUID() == null) {
            this.invalidParameterHandler.validateName(databaseColumnProperties.getDataType(), "databaseColumnProperties.dataType", "createDatabaseColumn");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/columns";
        return super.createReferenceableWithParent(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, "databaseTableGUID", databaseColumnProperties, "databaseColumnProperties", urlTemplate, "createDatabaseColumn");
    }

    @Override
    public String createDatabaseColumnFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseTableGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseColumnFromTemplate";
        String parentElementGUIDParameterName = "databaseTableGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/columns/from-template/{2}";
        return super.createReferenceableFromTemplateWithParent(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, "databaseTableGUID", templateGUID, templateProperties, urlTemplate, "createDatabaseColumnFromTemplate");
    }

    @Override
    public void updateDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, boolean isMergeUpdate, DatabaseColumnProperties databaseColumnProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDatabaseColumn";
        String elementGUIDParameterName = "databaseColumnGUID";
        String propertiesParameterName = "databaseColumnProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/columns/{2}";
        super.updateReferenceable(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", isMergeUpdate, databaseColumnProperties, "databaseColumnProperties", urlTemplate, "updateDatabaseColumn");
    }

    @Override
    public void removeDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDatabaseColumn";
        String elementGUIDParameterName = "databaseColumnGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/columns/{2}/delete";
        super.removeReferenceable(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", urlTemplate, "removeDatabaseColumn");
    }

    @Override
    public List<DatabaseColumnElement> findDatabaseColumns(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDatabaseColumns";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDatabaseColumns");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDatabaseColumns");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDatabaseColumns");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/columns/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        DatabaseColumnsResponse restResult = this.restClient.callDatabaseColumnsPostRESTCall("findDatabaseColumns", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public List<DatabaseColumnElement> getColumnsForDatabaseTable(String userId, String databaseTableGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getColumnsForDatabaseTable";
        String parentElementGUIDParameterName = "databaseTableGUID";
        this.invalidParameterHandler.validateUserId(userId, "getColumnsForDatabaseTable");
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", "getColumnsForDatabaseTable");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getColumnsForDatabaseTable");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/{2}/columns?startFrom={3}&pageSize={4}";
        DatabaseColumnsResponse restResult = this.restClient.callDatabaseColumnsGetRESTCall("getColumnsForDatabaseTable", urlTemplate, this.serverName, userId, databaseTableGUID, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public List<DatabaseColumnElement> getDatabaseColumnsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseColumnsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseColumnsByName");
        this.invalidParameterHandler.validateName(name, "name", "getDatabaseColumnsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDatabaseColumnsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/columns/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        DatabaseColumnsResponse restResult = this.restClient.callDatabaseColumnsPostRESTCall("getDatabaseColumnsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public DatabaseColumnElement getDatabaseColumnByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseColumnByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseColumnByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDatabaseColumnByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/columns/{2}";
        DatabaseColumnResponse restResult = this.restClient.callDatabaseColumnGetRESTCall("getDatabaseColumnByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    @Override
    public void setPrimaryKeyOnColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, DatabasePrimaryKeyProperties databasePrimaryKeyProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setPrimaryKeyOnColumn";
        String elementGUIDParameterName = "databaseColumnGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/columns/{2}/primary-key";
        this.setReferenceableClassification(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", databasePrimaryKeyProperties, urlTemplate, "setPrimaryKeyOnColumn");
    }

    @Override
    public void removePrimaryKeyFromColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removePrimaryKeyFromColumn";
        String elementGUIDParameterName = "databaseColumnGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/columns/{2}/primary-key/delete";
        super.removeReferenceableClassification(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", urlTemplate, "removePrimaryKeyFromColumn");
    }

    @Override
    public void addForeignKeyRelationship(String userId, String databaseManagerGUID, String databaseManagerName, String primaryKeyColumnGUID, String foreignKeyColumnGUID, DatabaseForeignKeyProperties databaseForeignKeyProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addForeignKeyRelationship";
        String primaryElementGUIDParameterName = "primaryKeyColumnGUID";
        String foreignElementGUIDParameterName = "foreignKeyColumnGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/columns/{2}/foreign-key/{3}";
        super.setupRelationship(userId, databaseManagerGUID, databaseManagerName, primaryKeyColumnGUID, "primaryKeyColumnGUID", databaseForeignKeyProperties, foreignKeyColumnGUID, "foreignKeyColumnGUID", urlTemplate, "addForeignKeyRelationship");
    }

    @Override
    public void removeForeignKeyRelationship(String userId, String databaseManagerGUID, String databaseManagerName, String primaryKeyColumnGUID, String foreignKeyColumnGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeForeignKeyRelationship";
        String primaryElementGUIDParameterName = "primaryKeyColumnGUID";
        String foreignElementGUIDParameterName = "foreignKeyColumnGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/tables/columns/{2}/foreign-key/{3}/delete";
        super.clearRelationship(userId, databaseManagerGUID, databaseManagerName, primaryKeyColumnGUID, "primaryKeyColumnGUID", foreignKeyColumnGUID, "foreignKeyColumnGUID", urlTemplate, "removeForeignKeyRelationship");
    }
}

