/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import org.odpi.openmetadata.accessservices.datamanager.api.MetadataSourceInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerBaseClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.APIManagerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ApplicationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataProcessingEngineRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.DatabaseManagerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.EventBrokerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FileManagerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FileSystemRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.APIManagerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.ApplicationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.DataProcessingEngineProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.DatabaseManagerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.EventBrokerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.FileManagerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.FileSystemProperties;

public class MetadataSourceClient
extends DataManagerBaseClient
implements MetadataSourceInterface {
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources";

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    @Override
    public String createAPIManager(String userId, String externalSourceGUID, String externalSourceName, APIManagerProperties apiManagerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAPIManager";
        String propertiesParameterName = "apiManagerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createAPIManager");
        this.invalidParameterHandler.validateObject(apiManagerProperties, "apiManagerProperties", "createAPIManager");
        this.invalidParameterHandler.validateName(apiManagerProperties.getQualifiedName(), "qualifiedName", "createAPIManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/api-managers";
        APIManagerRequestBody requestBody = new APIManagerRequestBody(apiManagerProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createAPIManager", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    @Override
    public String createDatabaseManager(String userId, String externalSourceGUID, String externalSourceName, DatabaseManagerProperties databaseManagerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseManager";
        String propertiesParameterName = "databaseManagerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseManager");
        this.invalidParameterHandler.validateObject(databaseManagerProperties, "databaseManagerProperties", "createDatabaseManager");
        this.invalidParameterHandler.validateName(databaseManagerProperties.getQualifiedName(), "qualifiedName", "createDatabaseManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/database-managers";
        DatabaseManagerRequestBody requestBody = new DatabaseManagerRequestBody(databaseManagerProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseManager", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    @Override
    public String createEventBroker(String userId, String externalSourceGUID, String externalSourceName, EventBrokerProperties eventBrokerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEventBroker";
        String propertiesParameterName = "eventBrokerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createEventBroker");
        this.invalidParameterHandler.validateObject(eventBrokerProperties, "eventBrokerProperties", "createEventBroker");
        this.invalidParameterHandler.validateName(eventBrokerProperties.getQualifiedName(), "qualifiedName", "createEventBroker");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/event-brokers";
        EventBrokerRequestBody requestBody = new EventBrokerRequestBody(eventBrokerProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEventBroker", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    @Override
    public String createFileSystem(String userId, String externalSourceGUID, String externalSourceName, FileSystemProperties fileSystemProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createFileSystem";
        String propertiesParameterName = "fileSystemProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createFileSystem");
        this.invalidParameterHandler.validateObject(fileSystemProperties, "fileSystemProperties", "createFileSystem");
        this.invalidParameterHandler.validateName(fileSystemProperties.getQualifiedName(), "qualifiedName", "createFileSystem");
        FileSystemRequestBody requestBody = new FileSystemRequestBody(fileSystemProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/filesystems";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createFileSystem", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    @Override
    public String createFileManager(String userId, String externalSourceGUID, String externalSourceName, FileManagerProperties fileManagerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createFileManager";
        String propertiesParameterName = "fileManagerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createFileManager");
        this.invalidParameterHandler.validateObject(fileManagerProperties, "fileManagerProperties", "createFileManager");
        this.invalidParameterHandler.validateName(fileManagerProperties.getQualifiedName(), "qualifiedName", "createFileManager");
        FileManagerRequestBody requestBody = new FileManagerRequestBody(fileManagerProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/file-managers";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createFileManager", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    @Override
    public String createApplication(String userId, String externalSourceGUID, String externalSourceName, ApplicationProperties applicationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createApplication";
        String propertiesParameterName = "applicationProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createApplication");
        this.invalidParameterHandler.validateObject(applicationProperties, "applicationProperties", "createApplication");
        this.invalidParameterHandler.validateName(applicationProperties.getQualifiedName(), "qualifiedName", "createApplication");
        ApplicationRequestBody requestBody = new ApplicationRequestBody(applicationProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/applications";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createApplication", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    @Override
    public String createDataProcessingEngine(String userId, String externalSourceGUID, String externalSourceName, DataProcessingEngineProperties engineProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataProcessingEngine";
        String propertiesParameterName = "engineProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDataProcessingEngine");
        this.invalidParameterHandler.validateObject(engineProperties, "engineProperties", "createDataProcessingEngine");
        this.invalidParameterHandler.validateName(engineProperties.getQualifiedName(), "qualifiedName", "createDataProcessingEngine");
        DataProcessingEngineRequestBody requestBody = new DataProcessingEngineRequestBody(engineProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/data-processing-engines";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDataProcessingEngine", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    @Override
    public String getMetadataSourceGUID(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataSourceGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataSourceGUID");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getMetadataSourceGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/by-name";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(qualifiedName);
        requestBody.setNamePropertyName("qualifiedName");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("getMetadataSourceGUID", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }
}

