/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.connectors.outtopic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.concurrent.CompletionException;
import org.odpi.openmetadata.accessservices.datamanager.events.DataManagerOutboundEvent;
import org.odpi.openmetadata.accessservices.datamanager.ffdc.DataManagerAuditCode;
import org.odpi.openmetadata.accessservices.datamanager.ffdc.DataManagerErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicSenderConnectorBase;

public class DataManagerOutTopicServerConnector
extends OpenMetadataTopicSenderConnectorBase {
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writer();

    public void sendEvent(DataManagerOutboundEvent event) throws InvalidParameterException, ConnectorCheckedException {
        String methodName = "sendEvent";
        try {
            String eventString = OBJECT_WRITER.writeValueAsString(event);
            super.sendEvent(eventString).join();
            if (this.auditLog != null) {
                this.auditLog.logMessage("sendEvent", DataManagerAuditCode.OUT_TOPIC_EVENT.getMessageDefinition(event.getEventType().getEventTypeName()), eventString);
            }
        }
        catch (CompletionException error) {
            if (error.getCause() instanceof ConnectorCheckedException) {
                throw (ConnectorCheckedException)error.getCause();
            }
            if (error.getCause() instanceof InvalidParameterException) {
                throw (InvalidParameterException)error.getCause();
            }
        }
        catch (ConnectorCheckedException | InvalidParameterException error) {
            throw error;
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(DataManagerErrorCode.UNABLE_TO_SEND_EVENT.getMessageDefinition(this.connectionName, event.toString(), error.getClass().getName(), error.getMessage()), this.getClass().getName(), "sendEvent", error);
        }
    }
}

