/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.restclients.factory;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.spring.SpringRESTClientConnectorProvider;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.SecretsStoreConnector;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementOriginCategory;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementOrigin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTClientFactory {
    private static final Logger log = LoggerFactory.getLogger(RESTClientFactory.class);
    private final Connection clientConnection;
    private final AuditLog auditLog;

    public RESTClientFactory(String serverName, String serverPlatformURLRoot) {
        this.clientConnection = this.getSpringRESTClientConnection(serverName, serverPlatformURLRoot, null, null, null);
        this.auditLog = null;
    }

    public RESTClientFactory(String serverName, String serverPlatformURLRoot, String userId, String password, Map<String, SecretsStoreConnector> secretsStoreConnectorMap, AuditLog auditLog) {
        this.clientConnection = this.getSpringRESTClientConnection(serverName, serverPlatformURLRoot, userId, password, secretsStoreConnectorMap);
        this.auditLog = auditLog;
    }

    private Connection getSpringRESTClientConnection(String serverName, String serverPlatformURLRoot, String userId, String password, Map<String, SecretsStoreConnector> secretsStoreConnectorMap) {
        Connection connection;
        if (secretsStoreConnectorMap == null || secretsStoreConnectorMap.isEmpty()) {
            connection = new Connection();
        } else {
            VirtualConnection virtualConnection = new VirtualConnection();
            ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
            for (String secretsConnectorName : secretsStoreConnectorMap.keySet()) {
                EmbeddedConnection embeddedConnection = new EmbeddedConnection();
                embeddedConnection.setDisplayName(secretsConnectorName);
                SecretsStoreConnector secretsStoreConnector = secretsStoreConnectorMap.get(secretsConnectorName);
                AccessibleConnection secretStoreConnection = new AccessibleConnection(secretsStoreConnector.getConnection());
                embeddedConnection.setEmbeddedConnection(secretStoreConnection.getConnectionBean());
                embeddedConnections.add(embeddedConnection);
            }
            virtualConnection.setEmbeddedConnections(embeddedConnections);
            connection = virtualConnection;
        }
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(serverPlatformURLRoot);
        endpoint.setDisplayName(serverName);
        endpoint.setQualifiedName(serverName);
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(SpringRESTClientConnectorProvider.class.getName()));
        connection.setQualifiedName(endpoint.getAddress());
        connection.setUserId(userId);
        connection.setClearPassword(password);
        return connection;
    }

    private ConnectorType getConnectorType(String connectorProviderClassName) {
        ConnectorType connectorType = null;
        if (connectorProviderClassName != null) {
            try {
                Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
                Object potentialConnectorProvider = connectorProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ConnectorProvider connectorProvider = (ConnectorProvider)potentialConnectorProvider;
                connectorType = connectorProvider.getConnectorType();
                if (connectorType == null) {
                    connectorType = new ConnectorType();
                    ElementOrigin elementOrigin = new ElementOrigin();
                    elementOrigin.setOriginCategory(ElementOriginCategory.CONFIGURATION);
                    connectorType.setOrigin(elementOrigin);
                    connectorType.setType(ConnectorType.getConnectorTypeType());
                    connectorType.setGUID(UUID.randomUUID().toString());
                    connectorType.setQualifiedName(connectorProviderClassName);
                    connectorType.setDisplayName(connectorProviderClass.getSimpleName());
                    connectorType.setDescription("ConnectorType for " + connectorType.getDisplayName());
                    connectorType.setConnectorProviderClassName(connectorProviderClassName);
                }
            }
            catch (Exception classException) {
                log.error("Bad connectorProviderClassName: " + classException.getMessage());
            }
        }
        return connectorType;
    }

    public RESTClientConnector getClientConnector() throws Exception {
        ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
        Connector connector = connectorBroker.getConnector(this.clientConnection);
        connector.start();
        return (RESTClientConnector)connector;
    }

    private static class AccessibleConnection
    extends ConnectionDetails {
        AccessibleConnection(ConnectionDetails templateConnection) {
            super(templateConnection);
        }

        @Override
        protected Connection getConnectionBean() {
            return super.getConnectionBean();
        }
    }
}

