/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.AdminServicesConfigHeader;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryMode;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenMetadataExchangeRule;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class LocalRepositoryConfig
extends AdminServicesConfigHeader {
    private String metadataCollectionId = null;
    private String metadataCollectionName = null;
    private LocalRepositoryMode localRepositoryMode = null;
    private Connection localRepositoryLocalConnection = null;
    private Connection localRepositoryRemoteConnection = null;
    private OpenMetadataExchangeRule eventsToSaveRule = null;
    private List<TypeDefSummary> selectedTypesToSave = null;
    private OpenMetadataExchangeRule eventsToSendRule = null;
    private List<TypeDefSummary> selectedTypesToSend = null;
    private Connection eventMapperConnection = null;

    public LocalRepositoryConfig() {
    }

    public LocalRepositoryConfig(LocalRepositoryConfig template) {
        super(template);
        if (template != null) {
            this.metadataCollectionId = template.getMetadataCollectionId();
            this.metadataCollectionName = template.getMetadataCollectionName();
            this.localRepositoryMode = template.getLocalRepositoryMode();
            this.localRepositoryLocalConnection = template.getLocalRepositoryLocalConnection();
            this.localRepositoryRemoteConnection = template.getLocalRepositoryRemoteConnection();
            this.eventsToSaveRule = template.getEventsToSaveRule();
            this.selectedTypesToSave = template.getSelectedTypesToSave();
            this.eventsToSendRule = template.getEventsToSendRule();
            this.selectedTypesToSend = template.getSelectedTypesToSend();
            this.eventMapperConnection = template.getEventMapperConnection();
        }
    }

    public String getMetadataCollectionId() {
        return this.metadataCollectionId;
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
    }

    public String getMetadataCollectionName() {
        return this.metadataCollectionName;
    }

    public void setMetadataCollectionName(String metadataCollectionName) {
        this.metadataCollectionName = metadataCollectionName;
    }

    public LocalRepositoryMode getLocalRepositoryMode() {
        return this.localRepositoryMode;
    }

    public void setLocalRepositoryMode(LocalRepositoryMode localRepositoryMode) {
        this.localRepositoryMode = localRepositoryMode;
    }

    public Connection getLocalRepositoryLocalConnection() {
        return this.localRepositoryLocalConnection;
    }

    public void setLocalRepositoryLocalConnection(Connection localRepositoryLocalConnection) {
        this.localRepositoryLocalConnection = localRepositoryLocalConnection;
    }

    public Connection getLocalRepositoryRemoteConnection() {
        return this.localRepositoryRemoteConnection;
    }

    public void setLocalRepositoryRemoteConnection(Connection localRepositoryRemoteConnection) {
        this.localRepositoryRemoteConnection = localRepositoryRemoteConnection;
    }

    public OpenMetadataExchangeRule getEventsToSaveRule() {
        return this.eventsToSaveRule;
    }

    public void setEventsToSaveRule(OpenMetadataExchangeRule eventsToSaveRule) {
        this.eventsToSaveRule = eventsToSaveRule;
    }

    public List<TypeDefSummary> getSelectedTypesToSave() {
        if (this.selectedTypesToSave == null) {
            return null;
        }
        if (this.selectedTypesToSave.isEmpty()) {
            return null;
        }
        ArrayList<TypeDefSummary> resultList = new ArrayList<TypeDefSummary>();
        for (TypeDefSummary typeDefSummary : this.selectedTypesToSave) {
            if (typeDefSummary == null) continue;
            resultList.add(new TypeDefSummary(typeDefSummary));
        }
        return resultList;
    }

    public void setSelectedTypesToSave(List<TypeDefSummary> selectedTypesToSave) {
        this.selectedTypesToSave = selectedTypesToSave;
    }

    public OpenMetadataExchangeRule getEventsToSendRule() {
        return this.eventsToSendRule;
    }

    public void setEventsToSendRule(OpenMetadataExchangeRule eventsToSendRule) {
        this.eventsToSendRule = eventsToSendRule;
    }

    public List<TypeDefSummary> getSelectedTypesToSend() {
        if (this.selectedTypesToSend == null) {
            return null;
        }
        if (this.selectedTypesToSend.isEmpty()) {
            return null;
        }
        ArrayList<TypeDefSummary> resultList = new ArrayList<TypeDefSummary>();
        for (TypeDefSummary typeDefSummary : this.selectedTypesToSend) {
            if (typeDefSummary == null) continue;
            resultList.add(new TypeDefSummary(typeDefSummary));
        }
        return resultList;
    }

    public void setSelectedTypesToSend(List<TypeDefSummary> selectedTypesToSend) {
        this.selectedTypesToSend = selectedTypesToSend;
    }

    public Connection getEventMapperConnection() {
        return this.eventMapperConnection;
    }

    public void setEventMapperConnection(Connection eventMapperConnection) {
        this.eventMapperConnection = eventMapperConnection;
    }

    public String toString() {
        return "LocalRepositoryConfig{metadataCollectionId='" + this.metadataCollectionId + "', metadataCollectionName='" + this.metadataCollectionName + "', localRepositoryMode=" + String.valueOf((Object)this.localRepositoryMode) + ", localRepositoryLocalConnection=" + String.valueOf(this.localRepositoryLocalConnection) + ", localRepositoryRemoteConnection=" + String.valueOf(this.localRepositoryRemoteConnection) + ", eventsToSaveRule=" + String.valueOf((Object)this.eventsToSaveRule) + ", selectedTypesToSave=" + String.valueOf(this.selectedTypesToSave) + ", eventsToSendRule=" + String.valueOf((Object)this.eventsToSendRule) + ", selectedTypesToSend=" + String.valueOf(this.selectedTypesToSend) + ", eventMapperConnection=" + String.valueOf(this.eventMapperConnection) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        LocalRepositoryConfig that = (LocalRepositoryConfig)objectToCompare;
        return Objects.equals(this.metadataCollectionId, that.metadataCollectionId) && Objects.equals(this.metadataCollectionName, that.metadataCollectionName) && this.localRepositoryMode == that.localRepositoryMode && Objects.equals(this.localRepositoryLocalConnection, that.localRepositoryLocalConnection) && Objects.equals(this.localRepositoryRemoteConnection, that.localRepositoryRemoteConnection) && this.eventsToSaveRule == that.eventsToSaveRule && Objects.equals(this.selectedTypesToSave, that.selectedTypesToSave) && this.eventsToSendRule == that.eventsToSendRule && Objects.equals(this.selectedTypesToSend, that.selectedTypesToSend) && Objects.equals(this.eventMapperConnection, that.eventMapperConnection);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getMetadataCollectionId(), this.getMetadataCollectionName(), this.getLocalRepositoryMode(), this.getLocalRepositoryLocalConnection(), this.getLocalRepositoryRemoteConnection(), this.getEventsToSaveRule(), this.getSelectedTypesToSave(), this.getEventsToSendRule(), this.getSelectedTypesToSend(), this.getEventMapperConnection()});
    }
}

