/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SolutionViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceRegistrationEntry;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SolutionViewServiceConfig.class, name="SolutionViewServiceConfig"), @JsonSubTypes.Type(value=IntegrationViewServiceConfig.class, name="IntegrationViewServiceConfig")})
public class ViewServiceConfig
extends OMAGServerClientConfig {
    private int viewServiceId = 0;
    private ComponentDevelopmentStatus viewServiceDevelopmentStatus = null;
    private String viewServiceAdminClass = null;
    private String viewServiceName = null;
    private String viewServiceFullName = null;
    private String viewServiceURLMarker = null;
    private String viewServiceDescription = null;
    private String viewServiceWiki = null;
    private String viewServicePartnerService = null;
    private ServiceOperationalStatus viewServiceOperationalStatus = null;
    private Map<String, Object> viewServiceOptions = null;

    public ViewServiceConfig() {
    }

    public ViewServiceConfig(ViewServiceConfig template) {
        super(template);
        if (template != null) {
            this.viewServiceId = template.getViewServiceId();
            this.viewServiceDevelopmentStatus = template.getViewServiceDevelopmentStatus();
            this.viewServiceAdminClass = template.getViewServiceAdminClass();
            this.viewServiceFullName = template.getViewServiceFullName();
            this.viewServiceName = template.getViewServiceName();
            this.viewServiceURLMarker = template.getViewServiceURLMarker();
            this.viewServiceDescription = template.getViewServiceDescription();
            this.viewServiceWiki = template.getViewServiceWiki();
            this.viewServicePartnerService = template.getViewServicePartnerService();
            this.viewServiceOperationalStatus = template.getViewServiceOperationalStatus();
            this.viewServiceOptions = template.getViewServiceOptions();
        }
    }

    public ViewServiceConfig(ViewServiceRegistrationEntry viewRegistration) {
        this.viewServiceId = viewRegistration.getViewServiceCode();
        this.viewServiceDevelopmentStatus = viewRegistration.getViewServiceDevelopmentStatus();
        this.viewServiceName = viewRegistration.getViewServiceName();
        this.viewServiceFullName = viewRegistration.getViewServiceFullName();
        this.viewServiceURLMarker = viewRegistration.getViewServiceURLMarker();
        this.viewServiceAdminClass = viewRegistration.getViewServiceAdminClassName();
        this.viewServiceDescription = viewRegistration.getViewServiceDescription();
        this.viewServiceWiki = viewRegistration.getViewServiceWiki();
        this.viewServicePartnerService = viewRegistration.getViewServicePartnerService();
        this.viewServiceOperationalStatus = viewRegistration.getViewServiceOperationalStatus();
    }

    public int getViewServiceId() {
        return this.viewServiceId;
    }

    public void setViewServiceId(int viewId) {
        this.viewServiceId = viewId;
    }

    public ComponentDevelopmentStatus getViewServiceDevelopmentStatus() {
        return this.viewServiceDevelopmentStatus;
    }

    public void setViewServiceDevelopmentStatus(ComponentDevelopmentStatus viewServiceDevelopmentStatus) {
        this.viewServiceDevelopmentStatus = viewServiceDevelopmentStatus;
    }

    public String getViewServiceAdminClass() {
        return this.viewServiceAdminClass;
    }

    public void setViewServiceAdminClass(String viewServiceAdminClass) {
        this.viewServiceAdminClass = viewServiceAdminClass;
    }

    public String getViewServiceFullName() {
        return this.viewServiceFullName;
    }

    public void setViewServiceFullName(String viewServiceFullName) {
        this.viewServiceFullName = viewServiceFullName;
    }

    public String getViewServiceName() {
        return this.viewServiceName;
    }

    public void setViewServiceName(String viewServiceName) {
        this.viewServiceName = viewServiceName;
    }

    public String getViewServiceURLMarker() {
        return this.viewServiceURLMarker;
    }

    public void setViewServiceURLMarker(String viewServiceURLMarker) {
        this.viewServiceURLMarker = viewServiceURLMarker;
    }

    public String getViewServiceDescription() {
        return this.viewServiceDescription;
    }

    public void setViewServiceDescription(String viewServiceDescription) {
        this.viewServiceDescription = viewServiceDescription;
    }

    public String getViewServiceWiki() {
        return this.viewServiceWiki;
    }

    public void setViewServiceWiki(String viewServiceWiki) {
        this.viewServiceWiki = viewServiceWiki;
    }

    public String getViewServicePartnerService() {
        return this.viewServicePartnerService;
    }

    public void setViewServicePartnerService(String viewServicePartnerService) {
        this.viewServicePartnerService = viewServicePartnerService;
    }

    public ServiceOperationalStatus getViewServiceOperationalStatus() {
        return this.viewServiceOperationalStatus;
    }

    public void setViewServiceOperationalStatus(ServiceOperationalStatus viewServiceOperationalStatus) {
        this.viewServiceOperationalStatus = viewServiceOperationalStatus;
    }

    public Map<String, Object> getViewServiceOptions() {
        if (this.viewServiceOptions == null) {
            return null;
        }
        if (this.viewServiceOptions.isEmpty()) {
            return null;
        }
        return this.viewServiceOptions;
    }

    public void setViewServiceOptions(Map<String, Object> viewServiceOptions) {
        this.viewServiceOptions = viewServiceOptions;
    }

    @Override
    public String toString() {
        return "ViewServiceConfig{viewServiceId=" + this.viewServiceId + ", viewServiceDevelopmentStatus=" + String.valueOf((Object)this.viewServiceDevelopmentStatus) + ", viewServiceAdminClass='" + this.viewServiceAdminClass + "', viewServiceName='" + this.viewServiceName + "', viewServiceFullName='" + this.viewServiceFullName + "', viewServiceURLMarker='" + this.viewServiceURLMarker + "', viewServiceDescription='" + this.viewServiceDescription + "', viewServiceWiki='" + this.viewServiceWiki + "', viewServicePartnerService='" + this.viewServicePartnerService + "', viewServiceOperationalStatus=" + String.valueOf((Object)this.viewServiceOperationalStatus) + ", viewServiceOptions=" + String.valueOf(this.viewServiceOptions) + ", OMAGServerPlatformRootURL='" + this.getOMAGServerPlatformRootURL() + "', OMAGServerName='" + this.getOMAGServerName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ViewServiceConfig that = (ViewServiceConfig)objectToCompare;
        return this.viewServiceId == that.viewServiceId && this.viewServiceDevelopmentStatus == that.viewServiceDevelopmentStatus && Objects.equals(this.viewServiceAdminClass, that.viewServiceAdminClass) && Objects.equals(this.viewServiceName, that.viewServiceName) && Objects.equals(this.viewServiceFullName, that.viewServiceFullName) && Objects.equals(this.viewServiceURLMarker, that.viewServiceURLMarker) && Objects.equals(this.viewServiceDescription, that.viewServiceDescription) && Objects.equals(this.viewServiceWiki, that.viewServiceWiki) && Objects.equals(this.viewServicePartnerService, that.viewServicePartnerService) && this.viewServiceOperationalStatus == that.viewServiceOperationalStatus && Objects.equals(this.viewServiceOptions, that.viewServiceOptions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.viewServiceId, this.viewServiceDevelopmentStatus, this.viewServiceAdminClass, this.viewServiceName, this.viewServiceFullName, this.viewServiceURLMarker, this.viewServiceDescription, this.viewServiceWiki, this.viewServicePartnerService, this.viewServiceOperationalStatus, this.viewServiceOptions});
    }
}

