/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;

public enum CommonServicesDescription {
    REPOSITORY_SERVICES(180, ComponentDevelopmentStatus.STABLE, "Open Metadata Repository Services (OMRS)", "repository-services", "Manages the synchronization, retrieval and maintenance of metadata stored in open metadata repositories.", "https://egeria-project.org/services/omrs", ServerTypeClassification.OMAG_SERVER.getServerTypeName(), "Open Metadata Repository Services (OMRS)", ServerTypeClassification.COHORT_MEMBER.getServerTypeName()),
    ADMINISTRATION_SERVICES(181, ComponentDevelopmentStatus.STABLE, "Administration Services", "admin-services", "Platform service providing configuration of services for an Open Metadata and Governance server (OMAG Server).", "https://egeria-project.org/services/admin-services/overview", null, "Administration Services", null),
    OCF_METADATA_MANAGEMENT(182, ComponentDevelopmentStatus.STABLE, "Connected Asset Services", "connected-asset", "Common metadata services for the Open Connector Framework (OCF).", "https://egeria-project.org/services/ocf-metadata-management", ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName(), null, null),
    OPEN_METADATA_SECURITY(183, ComponentDevelopmentStatus.STABLE, "Open Metadata Security Services", null, "Authorization services for Open Metadata and Governance", "https://egeria-project.org/services/metadata-security-services", ServerTypeClassification.OMAG_SERVER.getServerTypeName(), null, null),
    GAF_METADATA_MANAGEMENT(184, ComponentDevelopmentStatus.STABLE, "Governance Action Framework Services", "open-governance-service", "Support governance action services.", "https://egeria-project.org/services/gaf-metadata-management", ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName(), null, null),
    PLATFORM_SERVICES(185, ComponentDevelopmentStatus.STABLE, "Platform Operational Services", "platform-services", "A platform service that provides information about the registered services and connectors available in an OMAG Server Platform along with services to control and query information about the OMAG Servers running on the platform.", "https://egeria-project.org/services/platform-services/overview", null, null, null),
    OIF_METADATA_MANAGEMENT(186, ComponentDevelopmentStatus.STABLE, "Open Integration Service", "open-integration-service", "Provides operational support for the integration connectors.", "https://egeria-project.org/services/oif-metadata-management", ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName(), null, null),
    SERVER_OPERATIONS(187, ComponentDevelopmentStatus.STABLE, "Server Operations", "server-operations", "Supports the start up and shutdown of OMAG Servers.", "https://egeria-project.org/services/server-operations/overview", ServerTypeClassification.OMAG_SERVER.getServerTypeName(), null, null),
    OMF_METADATA_MANAGEMENT(188, ComponentDevelopmentStatus.STABLE, "Open Metadata Store Services", "open-metadata-store", "Provides generic open metadata retrieval and management services for the Open Frameworks and Open Metadata Access Services (OMASs).", "https://egeria-project.org/services/oms-metadata-management", ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName(), null, null);

    private final int serviceCode;
    private final ComponentDevelopmentStatus serviceDevelopmentStatus;
    private final String serviceName;
    private final String serviceURLMarker;
    private final String serviceDescription;
    private final String serviceWiki;
    private final String serverType;
    private final String partnerServiceName;
    private final String partnerServerType;

    private CommonServicesDescription(int serviceCode, ComponentDevelopmentStatus serviceDevelopmentStatus, String serviceName, String serviceURLMarker, String serviceDescription, String serviceWiki, String serverType, String partnerServiceName, String partnerServerType) {
        this.serviceCode = serviceCode;
        this.serviceDevelopmentStatus = serviceDevelopmentStatus;
        this.serviceName = serviceName;
        this.serviceURLMarker = serviceURLMarker;
        this.serviceDescription = serviceDescription;
        this.serviceWiki = serviceWiki;
        this.serverType = serverType;
        this.partnerServiceName = partnerServiceName;
        this.partnerServerType = partnerServerType;
    }

    public int getServiceCode() {
        return this.serviceCode;
    }

    public ComponentDevelopmentStatus getServiceDevelopmentStatus() {
        return this.serviceDevelopmentStatus;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceURLMarker() {
        return this.serviceURLMarker;
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public String getServiceWiki() {
        return this.serviceWiki;
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getPartnerServiceName() {
        return this.partnerServiceName;
    }

    public String getPartnerServerType() {
        return this.partnerServerType;
    }
}

