/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeQueryRequestBody;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetLineageGraphRequestBody
extends EffectiveTimeQueryRequestBody {
    private Date asOfTime = null;
    private List<String> relationshipTypes = null;
    private String limitToISCQualifiedName = null;
    private String highlightISCQualifiedName = null;
    private boolean allAnchors = false;

    public AssetLineageGraphRequestBody() {
    }

    public AssetLineageGraphRequestBody(AssetLineageGraphRequestBody template) {
        super(template);
        if (template != null) {
            this.asOfTime = template.getAsOfTime();
            this.relationshipTypes = template.getRelationshipTypes();
            this.limitToISCQualifiedName = template.getLimitToISCQualifiedName();
            this.highlightISCQualifiedName = template.getHighlightISCQualifiedName();
            this.allAnchors = template.getAllAnchors();
        }
    }

    public Date getAsOfTime() {
        return this.asOfTime;
    }

    public void setAsOfTime(Date asOfTime) {
        this.asOfTime = asOfTime;
    }

    public List<String> getRelationshipTypes() {
        return this.relationshipTypes;
    }

    public void setRelationshipTypes(List<String> relationshipTypes) {
        this.relationshipTypes = relationshipTypes;
    }

    public String getLimitToISCQualifiedName() {
        return this.limitToISCQualifiedName;
    }

    public void setLimitToISCQualifiedName(String limitToISCQualifiedName) {
        this.limitToISCQualifiedName = limitToISCQualifiedName;
    }

    public String getHighlightISCQualifiedName() {
        return this.highlightISCQualifiedName;
    }

    public void setHighlightISCQualifiedName(String highlightISCQualifiedName) {
        this.highlightISCQualifiedName = highlightISCQualifiedName;
    }

    public boolean getAllAnchors() {
        return this.allAnchors;
    }

    public void setAllAnchors(boolean allAnchors) {
        this.allAnchors = allAnchors;
    }

    @Override
    public String toString() {
        return "AssetLineageGraphRequestBody{asOfTime=" + String.valueOf(this.asOfTime) + ", relationshipTypes=" + String.valueOf(this.relationshipTypes) + ", limitToISCQualifiedName='" + this.limitToISCQualifiedName + "', highlightISCQualifiedName='" + this.highlightISCQualifiedName + "', allAnchors=" + this.allAnchors + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetLineageGraphRequestBody that = (AssetLineageGraphRequestBody)objectToCompare;
        return this.allAnchors == that.allAnchors && Objects.equals(this.asOfTime, that.asOfTime) && Objects.equals(this.relationshipTypes, that.relationshipTypes) && Objects.equals(this.limitToISCQualifiedName, that.limitToISCQualifiedName) && Objects.equals(this.highlightISCQualifiedName, that.highlightISCQualifiedName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.allAnchors, this.asOfTime, this.relationshipTypes, this.limitToISCQualifiedName, this.highlightISCQualifiedName);
    }
}

