/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.commonservices.ffdc.rest.FeedbackRequestBody;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommentType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CommentRequestBody
extends FeedbackRequestBody {
    private CommentType commentType = null;
    private String commentText = null;
    private String user = null;

    public CommentRequestBody() {
    }

    public CommentRequestBody(CommentRequestBody template) {
        super(template);
        if (template != null) {
            this.commentType = template.getCommentType();
            this.user = template.getUser();
            this.commentText = template.getCommentText();
        }
    }

    public CommentType getCommentType() {
        return this.commentType;
    }

    public void setCommentType(CommentType commentType) {
        this.commentType = commentType;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String toString() {
        return "CommentRequestBody{commentType=" + String.valueOf(this.commentType) + ", commentText='" + this.commentText + "', user='" + this.user + "', isPublic=" + this.getIsPublic() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CommentRequestBody that = (CommentRequestBody)objectToCompare;
        return this.commentType == that.commentType && Objects.equals(this.commentText, that.commentText) && Objects.equals(this.user, that.user);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.commentType != null ? this.commentType.hashCode() : 0);
        result = 31 * result + (this.commentText != null ? this.commentText.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        return result;
    }
}

