/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.commonservices.ffdc.rest.TemplateFilter;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ResultsRequestBody {
    private boolean forLineage = false;
    private boolean forDuplicateProcessing = false;
    private Date effectiveTime = null;
    private List<ElementStatus> limitResultsByStatus = null;
    private Date asOfTime = null;
    private SequencingOrder sequencingOrder = null;
    private String sequencingProperty = null;
    private TemplateFilter templateFilter = null;

    public ResultsRequestBody() {
    }

    public ResultsRequestBody(ResultsRequestBody template) {
        if (template != null) {
            this.forLineage = template.getForLineage();
            this.forDuplicateProcessing = template.getForDuplicateProcessing();
            this.effectiveTime = template.getEffectiveTime();
            this.limitResultsByStatus = template.getLimitResultsByStatus();
            this.asOfTime = template.getAsOfTime();
            this.sequencingOrder = template.getSequencingOrder();
            this.sequencingProperty = template.getSequencingProperty();
            this.templateFilter = template.getTemplateFilter();
        }
    }

    public boolean getForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    public boolean getForDuplicateProcessing() {
        return this.forDuplicateProcessing;
    }

    public void setForDuplicateProcessing(boolean forDuplicateProcessing) {
        this.forDuplicateProcessing = forDuplicateProcessing;
    }

    public Date getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public List<ElementStatus> getLimitResultsByStatus() {
        return this.limitResultsByStatus;
    }

    public void setLimitResultsByStatus(List<ElementStatus> limitResultsByStatus) {
        this.limitResultsByStatus = limitResultsByStatus;
    }

    public Date getAsOfTime() {
        return this.asOfTime;
    }

    public void setAsOfTime(Date asOfTime) {
        this.asOfTime = asOfTime;
    }

    public String getSequencingProperty() {
        return this.sequencingProperty;
    }

    public void setSequencingProperty(String sequencingProperty) {
        this.sequencingProperty = sequencingProperty;
    }

    public SequencingOrder getSequencingOrder() {
        return this.sequencingOrder;
    }

    public void setSequencingOrder(SequencingOrder sequencingOrder) {
        this.sequencingOrder = sequencingOrder;
    }

    public TemplateFilter getTemplateFilter() {
        return this.templateFilter;
    }

    public void setTemplateFilter(TemplateFilter templateFilter) {
        this.templateFilter = templateFilter;
    }

    public String toString() {
        return "ResultsRequestBody{forLineage=" + this.forLineage + ", forDuplicateProcessing=" + this.forDuplicateProcessing + ", effectiveTime=" + String.valueOf(this.effectiveTime) + ", limitResultsByStatus=" + String.valueOf(this.limitResultsByStatus) + ", asOfTime=" + String.valueOf(this.asOfTime) + ", sequencingOrder=" + String.valueOf((Object)this.sequencingOrder) + ", sequencingProperty='" + this.sequencingProperty + "', templateFilter=" + String.valueOf((Object)this.templateFilter) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ResultsRequestBody that = (ResultsRequestBody)objectToCompare;
        return this.forLineage == that.forLineage && this.forDuplicateProcessing == that.forDuplicateProcessing && Objects.equals(this.effectiveTime, that.effectiveTime) && Objects.equals(this.limitResultsByStatus, that.limitResultsByStatus) && Objects.equals(this.asOfTime, that.asOfTime) && this.sequencingOrder == that.sequencingOrder && this.templateFilter == that.templateFilter && Objects.equals(this.sequencingProperty, that.sequencingProperty);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.forLineage, this.forDuplicateProcessing, this.effectiveTime, this.templateFilter, this.limitResultsByStatus, this.asOfTime, this.sequencingOrder, this.sequencingProperty});
    }
}

