/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors;

import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.controls.SecretsStoreConfigurationProperty;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.users.NamedList;
import org.odpi.openmetadata.frameworks.connectors.properties.users.UserAccount;

public abstract class SecretsStoreConnector
extends ConnectorBase
implements AuditLoggingComponent {
    protected String secretsCollectionName = null;
    private Date secretsTimeout = new Date();

    @Override
    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    @Override
    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    @Override
    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.secretsCollectionName = super.getStringConfigurationProperty(SecretsStoreConfigurationProperty.SECRETS_COLLECTION_NAME.getName(), this.connectionDetails.getConfigurationProperties());
        if (this.secretsCollectionName == null) {
            this.throwMissingConfigurationProperty(this.getClass().getName(), "secrets", SecretsStoreConfigurationProperty.SECRETS_COLLECTION_NAME.getName(), "start");
        }
        this.checkSecretsStillValid();
    }

    public void checkSecretsStillValid() throws ConnectorCheckedException {
        if (this.secretsTimeout != null && !this.secretsTimeout.after(new Date())) {
            this.refreshSecrets();
            this.resetRefreshTime();
        }
    }

    protected abstract void refreshSecrets();

    protected void resetRefreshTime() throws ConnectorCheckedException {
        long refreshTimeInterval = this.getRefreshTimeInterval();
        if (refreshTimeInterval != 0L) {
            long newRefreshTime = new Date().getTime() + refreshTimeInterval * 60L * 1000L;
            this.secretsTimeout = new Date(newRefreshTime);
        }
    }

    public abstract String getSecret(String var1) throws ConnectorCheckedException;

    public abstract long getRefreshTimeInterval() throws ConnectorCheckedException;

    public UserAccount getUser(String userId) throws ConnectorCheckedException {
        return null;
    }

    public Map<String, UserAccount> getUsers() throws ConnectorCheckedException {
        return null;
    }

    public NamedList getNamedList(String listName) throws ConnectorCheckedException {
        return null;
    }

    public Map<String, NamedList> getNamedLists() throws ConnectorCheckedException {
        return null;
    }
}

