/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RelatedAsset
extends Asset {
    private String relationshipName = null;
    private String attributeName = null;

    public RelatedAsset() {
    }

    public RelatedAsset(RelatedAsset template) {
        super(template);
        if (template != null) {
            this.relationshipName = template.getRelationshipName();
            this.attributeName = template.getAttributeName();
        }
    }

    public String getRelationshipName() {
        return this.relationshipName;
    }

    public void setRelationshipName(String relationshipName) {
        this.relationshipName = relationshipName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public String toString() {
        return "RelatedAsset{resourceName='" + this.getResourceName() + "', versionIdentifier='" + this.getVersionIdentifier() + "', displayName='" + this.getDisplayName() + "', displaySummary='" + this.getDisplaySummary() + "', displayDescription='" + this.getDisplayDescription() + "', abbreviation='" + this.getAbbreviation() + "', usage='" + this.getUsage() + "', resourceDescription='" + this.getResourceDescription() + "', extendedProperties=" + String.valueOf(this.getExtendedProperties()) + ", status=" + String.valueOf(this.getStatus()) + ", type=" + String.valueOf(this.getType()) + ", origin=" + String.valueOf(this.getOrigin()) + ", versions=" + String.valueOf(this.getVersions()) + ", GUID='" + this.getGUID() + "', classifications=" + String.valueOf(this.getClassifications()) + ", meanings=" + String.valueOf(this.getMeanings()) + ", searchKeywords=" + String.valueOf(this.getSearchKeywords()) + ", headerVersion=" + this.getHeaderVersion() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        RelatedAsset that = (RelatedAsset)objectToCompare;
        return Objects.equals(this.getRelationshipName(), that.getRelationshipName()) && Objects.equals(this.getAttributeName(), that.getAttributeName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getRelationshipName(), this.getAttributeName());
    }
}

