/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalReference;
import org.odpi.openmetadata.frameworks.openmetadata.enums.MediaType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.MediaUsage;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RelatedMediaReference
extends ExternalReference {
    protected MediaType mediaType = null;
    protected List<MediaUsage> mediaUsageList = null;

    public RelatedMediaReference() {
    }

    public RelatedMediaReference(RelatedMediaReference templateRelatedMediaReference) {
        super(templateRelatedMediaReference);
        if (templateRelatedMediaReference != null) {
            this.mediaType = templateRelatedMediaReference.getMediaType();
            this.mediaUsageList = templateRelatedMediaReference.getMediaUsageList();
        }
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public List<MediaUsage> getMediaUsageList() {
        if (this.mediaUsageList == null) {
            return null;
        }
        return new ArrayList<MediaUsage>(this.mediaUsageList);
    }

    public void setMediaUsageList(List<MediaUsage> mediaUsageList) {
        this.mediaUsageList = mediaUsageList;
    }

    @Override
    public String toString() {
        return "RelatedMediaReference{extendedProperties=" + String.valueOf(this.getExtendedProperties()) + ", status=" + String.valueOf(this.getStatus()) + ", type=" + String.valueOf(this.getType()) + ", origin=" + String.valueOf(this.getOrigin()) + ", versions=" + String.valueOf(this.getVersions()) + ", GUID='" + this.getGUID() + "', classifications=" + String.valueOf(this.getClassifications()) + ", referenceId='" + this.getReferenceId() + "', linkDescription='" + this.getLinkDescription() + "', displayName='" + this.getDisplayName() + "', URI='" + this.getURI() + "', resourceDescription='" + this.getResourceDescription() + "', version='" + this.getVersion() + "', organization='" + this.getOrganization() + "', headerVersion=" + this.getHeaderVersion() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ", mediaType=" + String.valueOf(this.mediaType) + ", mediaUsageList=" + String.valueOf(this.mediaUsageList) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RelatedMediaReference that = (RelatedMediaReference)objectToCompare;
        return this.getMediaType() == that.getMediaType() && Objects.equals(this.getMediaUsageList(), that.getMediaUsageList());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMediaType(), this.getMediaUsageList());
    }
}

