/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.users.AccessOperation;
import org.odpi.openmetadata.frameworks.connectors.properties.users.UserAccountStatus;
import org.odpi.openmetadata.frameworks.connectors.properties.users.UserAccountType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class UserAccount {
    private String userName = null;
    private UserAccountType userAccountType = null;
    private String employeeNumber = null;
    private String employeeType = null;
    private String displayName = null;
    private String givenName = null;
    private String surname = null;
    private String email = null;
    private String manager = null;
    private String distinguishedName = null;
    private List<String> securityRoles = null;
    private List<String> securityGroups = null;
    private Map<String, List<AccessOperation>> zoneAccess = null;
    private Map<String, Object> otherProperties = null;
    private UserAccountStatus userAccountStatus = UserAccountStatus.DISABLED;
    private Map<String, String> secrets = null;

    public UserAccount() {
    }

    public UserAccount(UserAccount template) {
        if (template != null) {
            this.userName = template.getUserName();
            this.userAccountType = template.getAccountType();
            this.employeeNumber = template.getEmployeeNumber();
            this.employeeType = template.getEmployeeType();
            this.displayName = template.getDisplayName();
            this.givenName = template.getGivenName();
            this.surname = template.getSurname();
            this.email = template.getEmail();
            this.manager = template.getManager();
            this.distinguishedName = template.getDistinguishedName();
            this.securityRoles = template.getSecurityRoles();
            this.securityGroups = template.getSecurityGroups();
            this.zoneAccess = template.getZoneAccess();
            this.otherProperties = template.getOtherProperties();
            this.userAccountStatus = template.getUserAccountStatus();
            this.secrets = template.getSecrets();
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public UserAccountType getAccountType() {
        return this.userAccountType;
    }

    public void setAccountType(UserAccountType userAccountType) {
        this.userAccountType = userAccountType;
    }

    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    public String getEmployeeType() {
        return this.employeeType;
    }

    public void setEmployeeType(String employeeType) {
        this.employeeType = employeeType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getManager() {
        return this.manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    public void setDistinguishedName(String distinguishedName) {
        this.distinguishedName = distinguishedName;
    }

    public List<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public void setSecurityRoles(List<String> securityRoles) {
        this.securityRoles = securityRoles;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(List<String> securityGroups) {
        this.securityGroups = securityGroups;
    }

    public Map<String, List<AccessOperation>> getZoneAccess() {
        return this.zoneAccess;
    }

    public void setZoneAccess(Map<String, List<AccessOperation>> zoneAccess) {
        this.zoneAccess = zoneAccess;
    }

    public Map<String, Object> getOtherProperties() {
        return this.otherProperties;
    }

    public void setOtherProperties(Map<String, Object> otherProperties) {
        this.otherProperties = otherProperties;
    }

    public UserAccountStatus getUserAccountStatus() {
        return this.userAccountStatus;
    }

    public void setUserAccountStatus(UserAccountStatus userAccountStatus) {
        this.userAccountStatus = userAccountStatus;
    }

    public Map<String, String> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(Map<String, String> secrets) {
        this.secrets = secrets;
    }

    public String toString() {
        return "UserAccount{userName='" + this.userName + "', userAccountType='" + String.valueOf((Object)this.userAccountType) + "', employeeNumber='" + this.employeeNumber + "', employeeType='" + this.employeeType + "', displayName='" + this.displayName + "', givenName='" + this.givenName + "', surname='" + this.surname + "', email='" + this.email + "', manager='" + this.manager + "', distinguishedName='" + this.distinguishedName + "', securityRoles=" + String.valueOf(this.securityRoles) + ", securityGroups=" + String.valueOf(this.securityGroups) + ", zoneAccess=" + String.valueOf(this.zoneAccess) + ", otherProperties=" + String.valueOf(this.otherProperties) + ", userAccountStatus=" + String.valueOf((Object)this.userAccountStatus) + ", secrets=" + String.valueOf(this.secrets) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        UserAccount that = (UserAccount)objectToCompare;
        return Objects.equals(this.userName, that.userName) && this.userAccountType == that.userAccountType && Objects.equals(this.employeeNumber, that.employeeNumber) && Objects.equals(this.employeeType, that.employeeType) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.givenName, that.givenName) && Objects.equals(this.surname, that.surname) && Objects.equals(this.email, that.email) && Objects.equals(this.manager, that.manager) && Objects.equals(this.distinguishedName, that.distinguishedName) && Objects.equals(this.securityRoles, that.securityRoles) && Objects.equals(this.securityGroups, that.securityGroups) && Objects.equals(this.otherProperties, that.otherProperties) && this.userAccountStatus == that.userAccountStatus && Objects.equals(this.secrets, that.secrets);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userName, this.userAccountType, this.employeeNumber, this.employeeType, this.displayName, this.givenName, this.surname, this.email, this.manager, this.distinguishedName, this.securityRoles, this.securityGroups, this.otherProperties, this.userAccountStatus, this.secrets});
    }
}

