/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTargetType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public enum ActionTarget {
    ANY_ELEMENT("*", "Any type of element.", OpenMetadataType.OPEN_METADATA_ROOT.typeName, null),
    ANY_REFERENCEABLE("*", "Any element of type Referenceable (or a subtype of).", OpenMetadataType.REFERENCEABLE.typeName, null),
    ANY_ASSET("*", "Any element of type Asset (or a subtype of).", OpenMetadataType.ASSET.typeName, null),
    NEW_ASSET("newAsset", "A newly created Asset (or a subtype of).", OpenMetadataType.ASSET.typeName, null),
    DELETED_ASSET("deletedAsset", "A newly deleted Asset (or a subtype of).", OpenMetadataType.ASSET.typeName, null),
    PROCESS_OWNER("processOwner", "A person or team who is accountable for the correct operation of a process.", OpenMetadataType.ACTOR.typeName, null),
    DATA_OWNER("dataOwner", "A person or team who is accountable for the correct management and use of a particular collection of data.", OpenMetadataType.ACTOR.typeName, null),
    DATA_SUBJECT("dataSubject", "A person that is described by some data.", OpenMetadataType.ACTOR.typeName, null),
    CUSTODIAN("custodian", "The person, or team who is responsible for the correct management and use of a particular collection of data inside the consuming organization.", OpenMetadataType.ACTOR.typeName, null),
    STEWARD("steward", "The person, or team who is responsible for setting up the governance metadata associated with a resource.", OpenMetadataType.ACTOR.typeName, null),
    SPONSOR("sponsor", "The person, or team, or project who is sponsoring the overall activity associated with this resource.", OpenMetadataType.REFERENCEABLE.typeName, null),
    INTEGRATION_CONNECTOR("integrationConnector", "An integration connector that the service should work with.", DeployedImplementationType.INTEGRATION_CONNECTOR.getAssociatedTypeName(), DeployedImplementationType.INTEGRATION_CONNECTOR.getDeployedImplementationType());

    public final String name;
    public final String description;
    public final String typeName;
    private final String deployedImplementationType;

    private ActionTarget(String name, String description, String typeName, String deployedImplementationType) {
        this.name = name;
        this.description = description;
        this.typeName = typeName;
        this.deployedImplementationType = deployedImplementationType;
    }

    public static List<ActionTargetType> getActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        for (ActionTarget actionTarget : ActionTarget.values()) {
            actionTargetTypes.add(actionTarget.getActionTargetType());
        }
        return actionTargetTypes;
    }

    public ActionTargetType getActionTargetType() {
        ActionTargetType actionTargetType = new ActionTargetType();
        actionTargetType.setName(this.name);
        actionTargetType.setDescription(this.description);
        actionTargetType.setTypeName(this.typeName);
        actionTargetType.setDeployedImplementationType(this.deployedImplementationType);
        return actionTargetType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public String toString() {
        return "ActionTarget{name='" + this.name + "}";
    }
}

