/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ActionTargetElement
extends NewActionTarget {
    private String actionTargetRelationshipGUID = null;
    private EngineActionStatus status = null;
    private Date startDate = null;
    private Date completionDate = null;
    private String completionMessage = null;
    private OpenMetadataElement targetElement = null;

    public ActionTargetElement() {
    }

    public ActionTargetElement(ActionTargetElement template) {
        super(template);
        if (template != null) {
            this.actionTargetRelationshipGUID = template.getActionTargetRelationshipGUID();
            this.status = template.getStatus();
            this.startDate = template.getStartDate();
            this.completionDate = template.getCompletionDate();
            this.completionMessage = template.getCompletionMessage();
            this.targetElement = template.getTargetElement();
        }
    }

    public String getActionTargetRelationshipGUID() {
        return this.actionTargetRelationshipGUID;
    }

    public void setActionTargetRelationshipGUID(String actionTargetRelationshipGUID) {
        this.actionTargetRelationshipGUID = actionTargetRelationshipGUID;
    }

    public EngineActionStatus getStatus() {
        return this.status;
    }

    public void setStatus(EngineActionStatus status) {
        this.status = status;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public String getCompletionMessage() {
        return this.completionMessage;
    }

    public void setCompletionMessage(String completionMessage) {
        this.completionMessage = completionMessage;
    }

    public OpenMetadataElement getTargetElement() {
        return this.targetElement;
    }

    public void setTargetElement(OpenMetadataElement targetElement) {
        this.targetElement = targetElement;
    }

    @Override
    public String toString() {
        return "ActionTargetElement{status=" + String.valueOf(this.status) + ", relationshipGUID=" + this.actionTargetRelationshipGUID + ", startDate=" + String.valueOf(this.startDate) + ", completionDate=" + String.valueOf(this.completionDate) + ", completionMessage='" + this.completionMessage + "', targetElement=" + String.valueOf(this.targetElement) + ", actionTargetName='" + this.getActionTargetName() + "', actionTargetGUID='" + this.getActionTargetGUID() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ActionTargetElement that = (ActionTargetElement)objectToCompare;
        return Objects.equals(this.actionTargetRelationshipGUID, that.actionTargetRelationshipGUID) && this.status == that.status && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.completionDate, that.completionDate) && Objects.equals(this.completionMessage, that.completionMessage) && Objects.equals(this.targetElement, that.targetElement);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.actionTargetRelationshipGUID, this.status, this.startDate, this.completionDate, this.completionMessage, this.targetElement);
    }
}

