/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.connectors;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.properties.RequestedCatalogTarget;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;

public abstract class CatalogTargetProcessorBase
extends RequestedCatalogTarget {
    protected final String connectorName;
    protected final AuditLog auditLog;
    protected final PropertyHelper propertyHelper = new PropertyHelper();

    public CatalogTargetProcessorBase(CatalogTarget template, Connector connectorToTarget, String connectorName, AuditLog auditLog) {
        super(template, connectorToTarget);
        this.connectorName = connectorName;
        this.auditLog = auditLog;
    }

    public abstract void refresh() throws ConnectorCheckedException;

    protected String getStringConfigurationProperty(String propertyName, Map<String, Object> configurationProperties) {
        if (configurationProperties != null && configurationProperties.get(propertyName) != null) {
            return configurationProperties.get(propertyName).toString();
        }
        return null;
    }

    protected Date getDateConfigurationProperty(String propertyName, Map<String, Object> configurationProperties) throws InvalidParameterException {
        String methodName = "getDateConfigurationProperty";
        if (configurationProperties != null && configurationProperties.get(propertyName) != null) {
            String dateInString = configurationProperties.get(propertyName).toString();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            try {
                return formatter.parse(dateInString);
            }
            catch (ParseException error) {
                throw new InvalidParameterException(OCFErrorCode.MALFORMED_DATE_CONFIGURATION_PROPERTY.getMessageDefinition(propertyName, dateInString), this.getClass().getName(), "getDateConfigurationProperty", (Exception)error, propertyName);
            }
        }
        return null;
    }
}

