/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.context;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.governanceaction.client.ActionControlInterface;
import org.odpi.openmetadata.frameworks.governanceaction.properties.EngineActionElement;
import org.odpi.openmetadata.frameworks.openmetadata.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.IncidentDependency;
import org.odpi.openmetadata.frameworks.openmetadata.properties.IncidentImpactedElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.contextevents.ContextEventImpactProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.contextevents.ContextEventProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.contextevents.DependentContextEventProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.contextevents.RelatedContextEventProperties;

public class StewardshipAction {
    private final OpenMetadataClient openMetadataStore;
    private final ActionControlInterface actionControlInterface;
    private final String userId;
    private final String originatorGUID;

    public StewardshipAction(OpenMetadataClient openMetadataStore, ActionControlInterface actionControlInterface, String userId, String originatorGUID) {
        this.openMetadataStore = openMetadataStore;
        this.actionControlInterface = actionControlInterface;
        this.userId = userId;
        this.originatorGUID = originatorGUID;
    }

    public String createIncidentReport(String qualifiedName, int domainIdentifier, String background, List<IncidentImpactedElement> impactedResources, List<IncidentDependency> previousIncidents, Map<String, Integer> incidentClassifiers, Map<String, String> additionalProperties, String originatorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.createIncidentReport(this.userId, qualifiedName, domainIdentifier, background, impactedResources, previousIncidents, incidentClassifiers, additionalProperties, originatorGUID);
    }

    public String openToDo(String qualifiedName, String title, String instructions, String category, int priority, Date dueDate, Map<String, String> additionalProperties, String assignToGUID, String sponsorGUID, List<NewActionTarget> actionTargets) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.openToDo(this.userId, qualifiedName, title, instructions, category, priority, dueDate, additionalProperties, assignToGUID, sponsorGUID, this.originatorGUID, actionTargets);
    }

    public String registerContextEvent(String anchorGUID, Map<String, DependentContextEventProperties> parentContextEvents, Map<String, DependentContextEventProperties> childContextEvents, Map<String, RelatedContextEventProperties> relatedContextEvents, Map<String, ContextEventImpactProperties> impactedElements, Map<String, RelationshipProperties> effectedDataResourceGUIDs, Map<String, RelationshipProperties> contextEventEvidenceGUIDs, ContextEventProperties contextEventProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.registerContextEvent(this.userId, anchorGUID, parentContextEvents, childContextEvents, relatedContextEvents, impactedElements, effectedDataResourceGUIDs, contextEventEvidenceGUIDs, contextEventProperties);
    }

    public String initiateEngineAction(String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, List<String> receivedGuards, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String processName, String requestSourceName, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.actionControlInterface.initiateEngineAction(this.userId, qualifiedName, domainIdentifier, displayName, description, requestSourceGUIDs, actionTargets, receivedGuards, startTime, governanceEngineName, requestType, requestParameters, processName, requestSourceName, originatorServiceName, originatorEngineName);
    }

    public String initiateGovernanceActionType(String governanceActionTypeQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, Map<String, String> requestParameters, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.actionControlInterface.initiateGovernanceActionType(this.userId, governanceActionTypeQualifiedName, requestSourceGUIDs, actionTargets, startTime, requestParameters, originatorServiceName, originatorEngineName);
    }

    public String initiateGovernanceActionProcess(String processQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, Map<String, String> requestParameters, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.actionControlInterface.initiateGovernanceActionProcess(this.userId, processQualifiedName, requestSourceGUIDs, actionTargets, startTime, requestParameters, originatorServiceName, originatorEngineName);
    }

    public EngineActionElement getEngineAction(String engineActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.actionControlInterface.getEngineAction(this.userId, engineActionGUID);
    }

    public void cancelEngineAction(String engineActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.actionControlInterface.cancelEngineAction(this.userId, engineActionGUID);
    }

    public List<EngineActionElement> getEngineActions(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.actionControlInterface.getEngineActions(this.userId, startFrom, pageSize);
    }

    public List<EngineActionElement> getActiveEngineActions(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.actionControlInterface.getActiveEngineActions(this.userId, startFrom, pageSize);
    }

    public List<EngineActionElement> findEngineActions(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.actionControlInterface.findEngineActions(this.userId, searchString, startFrom, pageSize);
    }

    public List<EngineActionElement> getEngineActionsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.actionControlInterface.getEngineActionsByName(this.userId, name, startFrom, pageSize);
    }
}

