/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.filelistener;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFAuditCode;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFErrorCode;
import org.odpi.openmetadata.frameworks.integration.filelistener.FileDirectoryListenerInterface;
import org.odpi.openmetadata.frameworks.integration.filelistener.FileListenerInterface;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesListenerManager {
    private static final Logger log = LoggerFactory.getLogger(FilesListenerManager.class);
    private static final int POLL_INTERVAL = 500;
    private final AuditLog auditLog;
    private final String connectorName;
    private final FileAlterationMonitor monitor;

    public FilesListenerManager(AuditLog auditLog, String connectorName) {
        block2: {
            this.monitor = new FileAlterationMonitor(500L);
            String methodName = "FilesListenerManager";
            this.auditLog = auditLog;
            this.connectorName = connectorName;
            try {
                this.monitor.start();
            }
            catch (Exception error) {
                if (auditLog == null) break block2;
                auditLog.logException("FilesListenerManager", OIFAuditCode.UNEXPECTED_EXC_MONITOR_START.getMessageDefinition(error.getClass().getName(), connectorName, error.getMessage()), error);
            }
        }
    }

    public void registerFileListener(FileListenerInterface listener, File fileToMonitor) throws InvalidParameterException {
        String methodName = "registerFileListener";
        String listenerParameterName = "listener";
        String fileParameterName = "fileToMonitor";
        this.validateParameter(listener, "listener", "registerFileListener");
        this.validateParameter(fileToMonitor, "fileToMonitor", "registerFileListener");
        try {
            FileAlterationObserver observer = new FileAlterationObserver(fileToMonitor.getCanonicalPath());
            FileMonitoringListener managedListener = new FileMonitoringListener(listener);
            observer.addListener(managedListener);
            this.monitor.addObserver(observer);
            if (this.auditLog != null) {
                this.auditLog.logMessage("registerFileListener", OIFAuditCode.FILE_MONITORING_STARTING.getMessageDefinition(this.connectorName, fileToMonitor.getCanonicalPath()));
            }
        }
        catch (IOException exception) {
            throw new InvalidParameterException(OIFErrorCode.UNEXPECTED_IO_EXCEPTION.getMessageDefinition(), this.getClass().getName(), "registerFileListener", (Exception)exception, OpenMetadataProperty.PATH_NAME.name);
        }
    }

    public void unregisterFileListener(FileListenerInterface listener, File fileToMonitor) throws InvalidParameterException {
    }

    public void registerDirectoryListener(FileDirectoryListenerInterface listener, File directoryToMonitor, FileFilter fileFilter) throws InvalidParameterException {
        String methodName = "registerDirectoryListener";
        String listenerParameterName = "listener";
        String directoryParameterName = "directoryToMonitor";
        this.validateParameter(listener, "listener", "registerDirectoryListener");
        this.validateParameter(directoryToMonitor, "directoryToMonitor", "registerDirectoryListener");
        try {
            FileAlterationObserver observer = new FileAlterationObserver(directoryToMonitor.getCanonicalPath(), fileFilter);
            FolderMonitoringListener managedListener = new FolderMonitoringListener(listener, false, fileFilter);
            observer.addListener(managedListener);
            this.monitor.addObserver(observer);
            if (this.auditLog != null) {
                this.auditLog.logMessage("registerDirectoryListener", OIFAuditCode.DIRECTORY_MONITORING_STARTING.getMessageDefinition(this.connectorName, directoryToMonitor.getCanonicalPath()));
            }
        }
        catch (IOException exception) {
            throw new InvalidParameterException(OIFErrorCode.UNEXPECTED_IO_EXCEPTION.getMessageDefinition(), this.getClass().getName(), "registerDirectoryListener", (Exception)exception, OpenMetadataProperty.PATH_NAME.name);
        }
    }

    public void unregisterDirectoryListener(FileDirectoryListenerInterface listener, File directoryToMonitor) throws InvalidParameterException {
    }

    public void registerDirectoryTreeListener(FileDirectoryListenerInterface listener, File directoryToMonitor, FileFilter fileFilter) throws InvalidParameterException {
        String methodName = "registerDirectoryTreeListener";
        String listenerParameterName = "listener";
        String directoryParameterName = "directoryToMonitor";
        this.validateParameter(listener, "listener", "registerDirectoryTreeListener");
        this.validateParameter(directoryToMonitor, "directoryToMonitor", "registerDirectoryTreeListener");
        try {
            FileAlterationObserver observer = new FileAlterationObserver(directoryToMonitor.getCanonicalPath(), fileFilter);
            FolderMonitoringListener managedListener = new FolderMonitoringListener(listener, false, fileFilter);
            observer.addListener(managedListener);
            this.monitor.addObserver(observer);
            if (this.auditLog != null) {
                this.auditLog.logMessage("registerDirectoryTreeListener", OIFAuditCode.DIRECTORY_MONITORING_STARTING.getMessageDefinition(this.connectorName, directoryToMonitor.getCanonicalPath()));
            }
        }
        catch (IOException exception) {
            throw new InvalidParameterException(OIFErrorCode.UNEXPECTED_IO_EXCEPTION.getMessageDefinition(), this.getClass().getName(), "registerDirectoryTreeListener", (Exception)exception, OpenMetadataProperty.PATH_NAME.name);
        }
    }

    public void unregisterDirectoryTreeListener(FileDirectoryListenerInterface listener, File directoryToMonitor) throws InvalidParameterException {
    }

    public void disconnect() throws ConnectorCheckedException {
        block3: {
            String methodName = "disconnect";
            try {
                this.monitor.stop(1000L);
                if (this.auditLog != null) {
                    this.auditLog.logMessage("disconnect", OIFAuditCode.FILE_SYSTEM_MONITORING_STOPPING.getMessageDefinition(this.connectorName));
                }
            }
            catch (Exception error) {
                if (this.auditLog == null) break block3;
                this.auditLog.logException("disconnect", OIFAuditCode.UNEXPECTED_EXC_MONITOR_STOP.getMessageDefinition(error.getClass().getName(), this.connectorName, error.getMessage()), error);
            }
        }
    }

    public void validateParameter(Object object, String nameParameter, String methodName) throws InvalidParameterException {
        if (object == null) {
            throw new InvalidParameterException(OIFErrorCode.NULL_OBJECT.getMessageDefinition(nameParameter, methodName), this.getClass().getName(), methodName, nameParameter);
        }
    }

    static class FileMonitoringListener
    extends FileAlterationListenerAdaptor {
        private final FileListenerInterface fileListenerInterface;

        FileMonitoringListener(FileListenerInterface fileListenerInterface) {
            this.fileListenerInterface = fileListenerInterface;
        }

        @Override
        public void onFileCreate(File file) {
            log.debug("File created: " + file.getName());
            this.fileListenerInterface.onFileCreate(file);
        }

        @Override
        public void onFileDelete(File file) {
            log.debug("File deleted: " + file.getName());
            this.fileListenerInterface.onFileDelete(file);
        }

        @Override
        public void onFileChange(File file) {
            log.debug("File changed: " + file.getName());
            this.fileListenerInterface.onFileChange(file);
        }
    }

    class FolderMonitoringListener
    extends FileAlterationListenerAdaptor {
        private final FileDirectoryListenerInterface directoryListenerInterface;
        private final boolean monitorSubDirectories;
        private final FileFilter fileFilter;

        FolderMonitoringListener(FileDirectoryListenerInterface directoryListenerInterface, boolean monitorSubDirectories, FileFilter fileFilter) {
            this.directoryListenerInterface = directoryListenerInterface;
            this.monitorSubDirectories = monitorSubDirectories;
            this.fileFilter = fileFilter;
        }

        @Override
        public void onFileCreate(File file) {
            log.debug("File created: " + file.getName());
            this.directoryListenerInterface.onFileCreate(file);
        }

        @Override
        public void onFileDelete(File file) {
            log.debug("File deleted: " + file.getName());
            this.directoryListenerInterface.onFileDelete(file);
        }

        @Override
        public void onFileChange(File file) {
            log.debug("File changed: " + file.getName());
            this.directoryListenerInterface.onFileChange(file);
        }

        @Override
        public void onDirectoryCreate(File directory) {
            block3: {
                String methodName = "onDirectoryCreate";
                log.debug("Folder created: " + directory.getName());
                this.directoryListenerInterface.onDirectoryCreate(directory);
                if (this.monitorSubDirectories) {
                    try {
                        FilesListenerManager.this.registerDirectoryListener(this.directoryListenerInterface, directory, this.fileFilter);
                    }
                    catch (Exception error) {
                        if (FilesListenerManager.this.auditLog == null) break block3;
                        FilesListenerManager.this.auditLog.logException("onDirectoryCreate", OIFAuditCode.UNEXPECTED_EXC_MONITOR_START.getMessageDefinition(error.getClass().getName(), FilesListenerManager.this.connectorName, error.getMessage()), error);
                    }
                }
            }
        }

        @Override
        public void onDirectoryDelete(File directory) {
            log.debug("Folder deleted: " + directory.getName());
            this.directoryListenerInterface.onDirectoryDelete(directory);
        }
    }
}

