/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.reports;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationReportProperties;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;

public class IntegrationReportWriter {
    private boolean activeReportPublishing = true;
    private final String userId;
    private Set<String> createdElements = new HashSet<String>();
    private Set<String> updatedElements = new HashSet<String>();
    private Set<String> deletedElements = new HashSet<String>();
    private Map<String, String> additionalProperties = new HashMap<String, String>();
    private Date startDate = null;
    private Date completionDate = null;
    private final String serverName;
    private final String connectorId;
    private final String integrationConnectorGUID;
    private final String connectorName;
    private final OpenIntegrationClient openIntegrationClient;

    public IntegrationReportWriter(String serverName, String connectorId, String integrationConnectorGUID, String connectorName, String userId, OpenIntegrationClient openIntegrationClient) {
        this.serverName = serverName;
        this.integrationConnectorGUID = integrationConnectorGUID;
        this.connectorId = connectorId;
        this.connectorName = connectorName;
        this.userId = userId;
        this.openIntegrationClient = openIntegrationClient;
    }

    public void startRecording() {
        this.startDate = new Date();
        this.completionDate = null;
        this.createdElements = new HashSet<String>();
        this.updatedElements = new HashSet<String>();
        this.deletedElements = new HashSet<String>();
        this.additionalProperties = new HashMap<String, String>();
    }

    public void publishReport() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (!(!this.activeReportPublishing || this.createdElements.isEmpty() && this.updatedElements.isEmpty() && this.deletedElements.isEmpty())) {
            IntegrationReportProperties report = new IntegrationReportProperties();
            report.setServerName(this.serverName);
            report.setConnectorId(this.connectorId);
            report.setConnectorName(this.connectorName);
            report.setRefreshStartDate(this.startDate);
            report.setRefreshCompletionDate(this.completionDate);
            report.setAdditionalProperties(this.additionalProperties);
            report.setCreatedElements(this.getReportElements(this.createdElements));
            report.setUpdatedElements(this.getReportElements(this.updatedElements));
            report.setDeletedElements(this.getReportElements(this.deletedElements));
            this.openIntegrationClient.publishIntegrationReport(this.userId, this.integrationConnectorGUID, report);
        }
        this.startRecording();
    }

    private List<String> getReportElements(Set<String> elementGUIDs) {
        if (elementGUIDs != null && !elementGUIDs.isEmpty()) {
            ArrayList<String> guids = new ArrayList<String>();
            for (String guid : elementGUIDs) {
                if (guid == null) continue;
                guids.add(guid);
            }
            return guids;
        }
        return null;
    }

    public void setActiveReportPublishing(boolean flag) {
        this.activeReportPublishing = flag;
    }

    public void reportElementCreation(String elementGUID) {
        this.createdElements.add(elementGUID);
    }

    public void reportElementUpdate(String elementGUID) {
        this.updatedElements.add(elementGUID);
    }

    public void reportElementDelete(String elementGUID) {
        this.deletedElements.add(elementGUID);
    }
}

