/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataClassElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries.DataClassProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class DataClassConverter<B>
extends OpenMetadataConverterBase<B> {
    public DataClassConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, OpenMetadataElement primaryElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DataClassElement) {
                DataClassElement bean = (DataClassElement)returnBean;
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                if (primaryElement == null) {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                } else {
                    bean.setProperties(this.getDataClassProperties(primaryElement));
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    protected DataClassProperties getDataClassProperties(OpenMetadataElement primaryElement) {
        if (primaryElement.getElementProperties() != null) {
            ElementProperties elementProperties = new ElementProperties(primaryElement.getElementProperties());
            DataClassProperties dataClassProperties = new DataClassProperties();
            dataClassProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
            dataClassProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
            dataClassProperties.setDisplayName(this.removeDisplayName(elementProperties));
            dataClassProperties.setDescription(this.removeDescription(elementProperties));
            dataClassProperties.setNamespace(this.removeNamespace(elementProperties));
            dataClassProperties.setMatchPropertyNames(this.removeMatchPropertyNames(elementProperties));
            dataClassProperties.setMatchThreshold(this.removeMatchThreshold(elementProperties));
            dataClassProperties.setSpecification(this.removeSpecification(elementProperties));
            dataClassProperties.setSpecificationDetails(this.removeSpecificationDetails(elementProperties));
            dataClassProperties.setDataType(this.removeDataType(elementProperties));
            dataClassProperties.setAllowsDuplicateValues(this.removeAllowsDuplicateValues(elementProperties));
            dataClassProperties.setIsCaseSensitive(this.removeIsCaseSensitive(elementProperties));
            dataClassProperties.setIsNullable(this.removeIsNullable(elementProperties));
            dataClassProperties.setDefaultValue(this.removeDefaultValue(elementProperties));
            dataClassProperties.setAverageValue(this.removeAverageValue(elementProperties));
            dataClassProperties.setValueList(this.removeValueList(elementProperties));
            dataClassProperties.setValueRangeFrom(this.removeValueRangeFrom(elementProperties));
            dataClassProperties.setValueRangeTo(this.removeValueRangeTo(elementProperties));
            dataClassProperties.setSampleValues(this.removeSampleValues(elementProperties));
            dataClassProperties.setDataPatterns(this.removeDataPatterns(elementProperties));
            dataClassProperties.setEffectiveFrom(primaryElement.getEffectiveFromTime());
            dataClassProperties.setEffectiveTo(primaryElement.getEffectiveToTime());
            dataClassProperties.setTypeName(primaryElement.getType().getTypeName());
            dataClassProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
            return dataClassProperties;
        }
        return null;
    }

    protected List<RelatedMetadataElementSummary> getDataClassHierarchy(Class<B> beanClass, List<RelatedMetadataElement> relatedMetadataElements) throws PropertyServerException {
        String methodName = "getDataClassHierarchy";
        if (relatedMetadataElements != null) {
            ArrayList<RelatedMetadataElementSummary> elementSummaries = new ArrayList<RelatedMetadataElementSummary>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements) {
                if (relatedMetadataElement == null || !this.propertyHelper.isTypeOf(relatedMetadataElement, OpenMetadataType.DATA_CLASS_HIERARCHY.typeName)) continue;
                elementSummaries.add(super.getRelatedElementSummary(beanClass, relatedMetadataElement, "getDataClassHierarchy"));
            }
            return elementSummaries;
        }
        return null;
    }

    protected List<RelatedMetadataElementSummary> getDataClassComposition(Class<B> beanClass, List<RelatedMetadataElement> relatedMetadataElements) throws PropertyServerException {
        String methodName = "getDataClassComposition";
        if (relatedMetadataElements != null) {
            ArrayList<RelatedMetadataElementSummary> elementSummaries = new ArrayList<RelatedMetadataElementSummary>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements) {
                if (relatedMetadataElement == null || !this.propertyHelper.isTypeOf(relatedMetadataElement, OpenMetadataType.DATA_CLASS_COMPOSITION.typeName)) continue;
                elementSummaries.add(super.getRelatedElementSummary(beanClass, relatedMetadataElement, "getDataClassComposition"));
            }
            return elementSummaries;
        }
        return null;
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, OpenMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DataClassElement) {
                DataClassElement bean = (DataClassElement)returnBean;
                if (primaryElement != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                    bean.setProperties(this.getDataClassProperties(primaryElement));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                if (relationships != null) {
                    bean.setNestedDataClasses(this.getDataClassComposition(beanClass, relationships));
                    bean.setSpecializedDataClasses(this.getDataClassHierarchy(beanClass, relationships));
                    bean.setExternalReferences(this.getAttribution(beanClass, relationships));
                    bean.setOtherRelatedElements(this.getOtherRelatedElements(beanClass, relationships, Arrays.asList(OpenMetadataType.DATA_CLASS_HIERARCHY.typeName, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, OpenMetadataType.DATA_CLASS_COMPOSITION.typeName)));
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

