/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataFieldElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries.DataFieldProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries.MemberDataFieldProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class DataFieldConverter<B>
extends OpenMetadataConverterBase<B> {
    public DataFieldConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, OpenMetadataElement primaryElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DataFieldElement) {
                DataFieldElement bean = (DataFieldElement)returnBean;
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                if (primaryElement == null) {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                } else {
                    bean.setProperties(this.getDataFieldProperties(primaryElement));
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    protected DataFieldProperties getDataFieldProperties(OpenMetadataElement primaryElement) {
        if (primaryElement.getElementProperties() != null) {
            ElementProperties elementProperties = new ElementProperties(primaryElement.getElementProperties());
            DataFieldProperties dataFieldProperties = new DataFieldProperties();
            dataFieldProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
            dataFieldProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
            dataFieldProperties.setDisplayName(this.removeDisplayName(elementProperties));
            dataFieldProperties.setNamespace(this.removeNamespace(elementProperties));
            dataFieldProperties.setAliases(this.removeAliases(elementProperties));
            dataFieldProperties.setNamePatterns(this.removeNamePatterns(elementProperties));
            dataFieldProperties.setDescription(this.removeDescription(elementProperties));
            dataFieldProperties.setIsDeprecated(this.removeIsDeprecated(elementProperties));
            dataFieldProperties.setVersionIdentifier(this.removeVersionIdentifier(elementProperties));
            dataFieldProperties.setDefaultValue(this.removeDefaultValue(elementProperties));
            dataFieldProperties.setIsNullable(this.removeIsNullable(elementProperties));
            dataFieldProperties.setIsDeprecated(this.removeIsDeprecated(elementProperties));
            dataFieldProperties.setDataType(this.removeDataType(elementProperties));
            dataFieldProperties.setUnits(this.removeUnits(elementProperties));
            dataFieldProperties.setMinimumLength(this.removeMinimumLength(elementProperties));
            dataFieldProperties.setLength(this.removeLength(elementProperties));
            dataFieldProperties.setPrecision(this.removePrecision(elementProperties));
            dataFieldProperties.setOrderedValues(this.removeOrderedValues(elementProperties));
            dataFieldProperties.setSortOrder(this.removeDataItemSortOrder(elementProperties));
            dataFieldProperties.setEffectiveFrom(primaryElement.getEffectiveFromTime());
            dataFieldProperties.setEffectiveTo(primaryElement.getEffectiveToTime());
            dataFieldProperties.setTypeName(primaryElement.getType().getTypeName());
            dataFieldProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
            return dataFieldProperties;
        }
        return null;
    }

    public MemberDataFieldProperties getMemberDataFieldProperties(RelatedMetadataElement relatedMetadataElement) {
        if (relatedMetadataElement.getRelationshipProperties() != null) {
            ElementProperties elementProperties = new ElementProperties(relatedMetadataElement.getRelationshipProperties());
            MemberDataFieldProperties dataFieldProperties = new MemberDataFieldProperties();
            dataFieldProperties.setDataFieldPosition(this.removePosition(elementProperties));
            dataFieldProperties.setMaxCardinality(this.removeMaxCardinality(elementProperties));
            dataFieldProperties.setMinCardinality(this.removeMinCardinality(elementProperties));
            dataFieldProperties.setEffectiveFrom(relatedMetadataElement.getEffectiveFromTime());
            dataFieldProperties.setEffectiveTo(relatedMetadataElement.getEffectiveToTime());
            dataFieldProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
            return dataFieldProperties;
        }
        return null;
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, OpenMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DataFieldElement) {
                DataFieldElement bean = (DataFieldElement)returnBean;
                if (primaryElement != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                    bean.setProperties(this.getDataFieldProperties(primaryElement));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                if (relationships != null) {
                    bean.setAssignedMeanings(this.getSemanticDefinition(beanClass, relationships));
                    bean.setAssignedDataClasses(this.getDataClassDefinition(beanClass, relationships));
                    bean.setExternalReferences(this.getAttribution(beanClass, relationships));
                    bean.setMemberOfCollections(this.getParentCollectionMembership(beanClass, relationships));
                    bean.setOtherRelatedElements(this.getOtherRelatedElements(beanClass, relationships, Arrays.asList(OpenMetadataType.SEMANTIC_DEFINITION_RELATIONSHIP.typeName, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, OpenMetadataType.DATA_CLASS_DEFINITION_RELATIONSHIP.typeName, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName)));
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

