/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.DataFieldConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataStructureElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries.DataStructureProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class DataStructureConverter<B>
extends DataFieldConverter<B> {
    public DataStructureConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, OpenMetadataElement primaryElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DataStructureElement) {
                DataStructureElement bean = (DataStructureElement)returnBean;
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                if (primaryElement == null) {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                } else {
                    bean.setProperties(this.getDataStructureProperties(primaryElement));
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    protected DataStructureProperties getDataStructureProperties(OpenMetadataElement primaryElement) {
        if (primaryElement.getElementProperties() != null) {
            ElementProperties elementProperties = new ElementProperties(primaryElement.getElementProperties());
            DataStructureProperties dataStructureProperties = new DataStructureProperties();
            dataStructureProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
            dataStructureProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
            dataStructureProperties.setDisplayName(this.removeDisplayName(elementProperties));
            dataStructureProperties.setDescription(this.removeDescription(elementProperties));
            dataStructureProperties.setNamespace(this.removeNamespace(elementProperties));
            dataStructureProperties.setVersionIdentifier(this.removeVersionIdentifier(elementProperties));
            dataStructureProperties.setEffectiveFrom(primaryElement.getEffectiveFromTime());
            dataStructureProperties.setEffectiveTo(primaryElement.getEffectiveToTime());
            dataStructureProperties.setTypeName(primaryElement.getType().getTypeName());
            dataStructureProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
            return dataStructureProperties;
        }
        return null;
    }

    protected RelatedMetadataElementSummary getEquivalentSchemaType(Class<B> beanClass, List<RelatedMetadataElement> relatedMetadataElements) throws PropertyServerException {
        String methodName = "getEquivalentSchemaType";
        if (relatedMetadataElements != null) {
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements) {
                if (relatedMetadataElement == null || !this.propertyHelper.isTypeOf(relatedMetadataElement, OpenMetadataType.SCHEMA_TYPE_DEFINITION.typeName)) continue;
                return super.getRelatedElementSummary(beanClass, relatedMetadataElement, "getEquivalentSchemaType");
            }
        }
        return null;
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, OpenMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DataStructureElement) {
                DataStructureElement bean = (DataStructureElement)returnBean;
                if (primaryElement != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                    bean.setProperties(this.getDataStructureProperties(primaryElement));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                if (relationships != null) {
                    bean.setEquivalentSchemaType(this.getEquivalentSchemaType(beanClass, relationships));
                    bean.setExternalReferences(this.getAttribution(beanClass, relationships));
                    bean.setMemberOfCollections(this.getParentCollectionMembership(beanClass, relationships));
                    bean.setOtherRelatedElements(this.getOtherRelatedElements(beanClass, relationships, Arrays.asList(OpenMetadataType.SCHEMA_TYPE_DEFINITION.typeName, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName)));
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

