/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.InformationSupplyChainElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.InformationSupplyChainSegmentElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.properties.informationsupplychains.InformationSupplyChainProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;

public class InformationSupplyChainConverter<B>
extends OpenMetadataConverterBase<B> {
    private final List<InformationSupplyChainSegmentElement> segments;
    private final List<OpenMetadataRelationship> implementation;

    public InformationSupplyChainConverter(PropertyHelper propertyHelper, String serviceName, String serverName, List<InformationSupplyChainSegmentElement> segments, List<OpenMetadataRelationship> implementation) {
        super(propertyHelper, serviceName, serverName);
        this.segments = segments;
        this.implementation = implementation;
    }

    @Override
    public B getNewBean(Class<B> beanClass, OpenMetadataElement primaryElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof InformationSupplyChainElement) {
                InformationSupplyChainElement bean = (InformationSupplyChainElement)returnBean;
                InformationSupplyChainProperties informationSupplyChainProperties = new InformationSupplyChainProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                bean.setSegments(this.segments);
                bean.setImplementation(super.getRelationshipElements(beanClass, this.implementation, methodName));
                if (primaryElement != null) {
                    ElementProperties elementProperties = new ElementProperties(primaryElement.getElementProperties());
                    informationSupplyChainProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
                    informationSupplyChainProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
                    informationSupplyChainProperties.setDisplayName(this.removeDisplayName(elementProperties));
                    informationSupplyChainProperties.setDescription(this.removeDescription(elementProperties));
                    informationSupplyChainProperties.setScope(this.removeScope(elementProperties));
                    informationSupplyChainProperties.setPurposes(this.removePurposes(elementProperties));
                    informationSupplyChainProperties.setEffectiveFrom(primaryElement.getEffectiveFromTime());
                    informationSupplyChainProperties.setEffectiveTo(primaryElement.getEffectiveToTime());
                    informationSupplyChainProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    informationSupplyChainProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                    bean.setProperties(informationSupplyChainProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                bean.setProperties(informationSupplyChainProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

