/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ImplementedByRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.InformationSupplyChainLink;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.InformationSupplyChainSegmentElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SolutionLinkingWireRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.informationsupplychains.InformationSupplyChainLinkProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.informationsupplychains.InformationSupplyChainSegmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.solutions.ImplementedByProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.solutions.SolutionLinkingWireProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class InformationSupplyChainSegmentConverter<B>
extends OpenMetadataConverterBase<B> {
    private final List<RelatedMetadataElementSummary> solutionComponentPorts;
    private final List<SolutionLinkingWireRelationship> solutionLinkingWires;

    public InformationSupplyChainSegmentConverter(PropertyHelper propertyHelper, String serviceName, String serverName, List<SolutionLinkingWireRelationship> solutionLinkingWire, List<RelatedMetadataElementSummary> solutionComponentPorts) {
        super(propertyHelper, serviceName, serverName);
        this.solutionComponentPorts = solutionComponentPorts;
        this.solutionLinkingWires = solutionLinkingWire;
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, OpenMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof InformationSupplyChainSegmentElement) {
                InformationSupplyChainSegmentElement bean = (InformationSupplyChainSegmentElement)returnBean;
                InformationSupplyChainSegmentProperties segmentProperties = new InformationSupplyChainSegmentProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                bean.setSolutionComponentPorts(this.solutionComponentPorts);
                bean.setSolutionLinkingWires(this.solutionLinkingWires);
                if (primaryElement != null) {
                    ElementProperties elementProperties = new ElementProperties(primaryElement.getElementProperties());
                    segmentProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
                    segmentProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
                    segmentProperties.setDisplayName(this.removeDisplayName(elementProperties));
                    segmentProperties.setDescription(this.removeDescription(elementProperties));
                    segmentProperties.setScope(this.removeScope(elementProperties));
                    segmentProperties.setIntegrationStyle(this.removeIntegrationStyle(elementProperties));
                    segmentProperties.setEstimatedVolumetrics(this.removeEstimatedVolumetrics(elementProperties));
                    segmentProperties.setEffectiveFrom(primaryElement.getEffectiveFromTime());
                    segmentProperties.setEffectiveTo(primaryElement.getEffectiveToTime());
                    segmentProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    segmentProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                    bean.setProperties(segmentProperties);
                    if (relationships != null) {
                        ArrayList<InformationSupplyChainLink> links = new ArrayList<InformationSupplyChainLink>();
                        ArrayList<ImplementedByRelationship> implementedByList = new ArrayList<ImplementedByRelationship>();
                        ElementStub segmentStub = this.getElementStub(beanClass, primaryElement, methodName);
                        for (RelatedMetadataElement relatedMetadataElement : relationships) {
                            if (relatedMetadataElement == null) continue;
                            if (this.propertyHelper.isTypeOf(relatedMetadataElement, OpenMetadataType.INFORMATION_SUPPLY_CHAIN_LINK_RELATIONSHIP.typeName)) {
                                links.add(this.getInformationSupplyChainLinkRelationship(beanClass, segmentStub, relatedMetadataElement));
                                continue;
                            }
                            if (!this.propertyHelper.isTypeOf(relatedMetadataElement, OpenMetadataType.IMPLEMENTED_BY_RELATIONSHIP.typeName)) continue;
                            implementedByList.add(this.getImplementedByRelationship(beanClass, segmentStub, relatedMetadataElement));
                        }
                        if (!links.isEmpty()) {
                            bean.setLinks(links);
                        }
                        if (!implementedByList.isEmpty()) {
                            bean.setImplementedByList(implementedByList);
                        }
                        if (!this.solutionComponentPorts.isEmpty()) {
                            bean.setSolutionComponentPorts(this.solutionComponentPorts);
                        }
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private ImplementedByRelationship getImplementedByRelationship(Class<B> beanClass, ElementStub segmentStub, RelatedMetadataElement relatedMetadataElement) throws PropertyServerException {
        String methodName = "getImplementedByRelationship";
        ImplementedByRelationship relationship = new ImplementedByRelationship();
        relationship.setElementHeader(this.getMetadataElementHeader(beanClass, relatedMetadataElement, relatedMetadataElement.getRelationshipGUID(), null, "getImplementedByRelationship"));
        ImplementedByProperties relationshipProperties = new ImplementedByProperties();
        ElementProperties elementProperties = new ElementProperties(relatedMetadataElement.getRelationshipProperties());
        relationshipProperties.setDesignStep(this.removeDesignStep(elementProperties));
        relationshipProperties.setRole(this.removeRole(elementProperties));
        relationshipProperties.setTransformation(this.removeTransformation(elementProperties));
        relationshipProperties.setDescription(this.removeDescription(elementProperties));
        relationshipProperties.setEffectiveFrom(relatedMetadataElement.getEffectiveFromTime());
        relationshipProperties.setEffectiveTo(relatedMetadataElement.getEffectiveToTime());
        relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
        relationship.setProperties(relationshipProperties);
        if (relatedMetadataElement.getElementAtEnd1()) {
            relationship.setEnd1Element(this.getElementStub(beanClass, relatedMetadataElement.getElement(), "getImplementedByRelationship"));
            relationship.setEnd2Element(segmentStub);
        } else {
            relationship.setEnd1Element(segmentStub);
            relationship.setEnd2Element(this.getElementStub(beanClass, relatedMetadataElement.getElement(), "getImplementedByRelationship"));
        }
        return relationship;
    }

    private InformationSupplyChainLink getInformationSupplyChainLinkRelationship(Class<B> beanClass, ElementStub segmentStub, RelatedMetadataElement relatedMetadataElement) throws PropertyServerException {
        String methodName = "getInformationSupplyChainLinkRelationship";
        InformationSupplyChainLink relationship = new InformationSupplyChainLink();
        relationship.setElementHeader(this.getMetadataElementHeader(beanClass, relatedMetadataElement, relatedMetadataElement.getRelationshipGUID(), null, "getInformationSupplyChainLinkRelationship"));
        InformationSupplyChainLinkProperties relationshipProperties = new InformationSupplyChainLinkProperties();
        ElementProperties elementProperties = new ElementProperties(relatedMetadataElement.getRelationshipProperties());
        relationshipProperties.setLabel(this.removeLabel(elementProperties));
        relationshipProperties.setDescription(this.removeDescription(elementProperties));
        relationshipProperties.setEffectiveFrom(relatedMetadataElement.getEffectiveFromTime());
        relationshipProperties.setEffectiveTo(relatedMetadataElement.getEffectiveToTime());
        relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
        relationship.setProperties(relationshipProperties);
        if (relatedMetadataElement.getElementAtEnd1()) {
            relationship.setEnd1Element(this.getElementStub(beanClass, relatedMetadataElement.getElement(), "getInformationSupplyChainLinkRelationship"));
            relationship.setEnd2Element(segmentStub);
        } else {
            relationship.setEnd1Element(segmentStub);
            relationship.setEnd2Element(this.getElementStub(beanClass, relatedMetadataElement.getElement(), "getInformationSupplyChainLinkRelationship"));
        }
        return relationship;
    }

    private SolutionLinkingWireRelationship getSolutionLinkingWireRelationship(Class<B> beanClass, ElementStub segmentStub, RelatedMetadataElement relatedMetadataElement) throws PropertyServerException {
        String methodName = "getISolutionLinkingWireRelationship";
        SolutionLinkingWireRelationship relationship = new SolutionLinkingWireRelationship();
        relationship.setElementHeader(this.getMetadataElementHeader(beanClass, relatedMetadataElement, relatedMetadataElement.getRelationshipGUID(), null, "getISolutionLinkingWireRelationship"));
        SolutionLinkingWireProperties relationshipProperties = new SolutionLinkingWireProperties();
        ElementProperties elementProperties = new ElementProperties(relatedMetadataElement.getRelationshipProperties());
        relationshipProperties.setLabel(this.removeLabel(elementProperties));
        relationshipProperties.setDescription(this.removeDescription(elementProperties));
        relationshipProperties.setInformationSupplyChainSegmentGUIDs(this.removeInformationSupplyChainSegmentGUIDs(elementProperties));
        relationshipProperties.setEffectiveFrom(relatedMetadataElement.getEffectiveFromTime());
        relationshipProperties.setEffectiveTo(relatedMetadataElement.getEffectiveToTime());
        relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
        relationship.setProperties(relationshipProperties);
        if (relatedMetadataElement.getElementAtEnd1()) {
            relationship.setEnd1Element(this.getElementStub(beanClass, relatedMetadataElement.getElement(), "getISolutionLinkingWireRelationship"));
            relationship.setEnd2Element(segmentStub);
        } else {
            relationship.setEnd1Element(segmentStub);
            relationship.setEnd2Element(this.getElementStub(beanClass, relatedMetadataElement.getElement(), "getISolutionLinkingWireRelationship"));
        }
        return relationship;
    }
}

