/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataRelationshipSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationshipList;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;

public class MetadataRelationshipSummaryConverter<B>
extends OpenMetadataConverterBase<B> {
    public MetadataRelationshipSummaryConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    @Override
    public B getNewRelatedMetadataElementsBean(Class<B> beanClass, OpenMetadataRelationship relationship, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewRelatedMetadataElementsBean";
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof MetadataRelationshipSummary) {
                MetadataRelationshipSummary elementSummary = (MetadataRelationshipSummary)returnBean;
                ElementHeader elementHeader = new ElementHeader(relationship);
                elementHeader.setGUID(relationship.getRelationshipGUID());
                elementSummary.setElementHeader(elementHeader);
                elementSummary.setEnd1(super.getElementStub(beanClass, relationship.getElementAtEnd1(), methodName));
                elementSummary.setEnd2(super.getElementStub(beanClass, relationship.getElementAtEnd2(), methodName));
                if (relationship.getRelationshipProperties() != null) {
                    elementSummary.setProperties(relationship.getRelationshipProperties().getPropertiesAsStrings());
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public List<B> getNewBeans(Class<B> beanClass, OpenMetadataRelationshipList openMetadataRelationships, String methodName) throws PropertyServerException {
        ArrayList<B> results = null;
        if (openMetadataRelationships != null && openMetadataRelationships.getElementList() != null) {
            results = new ArrayList<B>();
            for (OpenMetadataRelationship openMetadataElement : openMetadataRelationships.getElementList()) {
                if (openMetadataElement == null) continue;
                results.add(this.getNewRelatedMetadataElementsBean(beanClass, openMetadataElement, methodName));
            }
        }
        return results;
    }
}

