/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProjectElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.ProjectProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class ProjectConverter<B>
extends OpenMetadataConverterBase<B> {
    public ProjectConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, OpenMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ProjectElement) {
                ProjectElement bean = (ProjectElement)returnBean;
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                if (primaryElement == null) {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                } else {
                    bean.setProperties(this.getProjectProperties(primaryElement));
                    bean.setResourceList(this.getResourceList(beanClass, relationships));
                    bean.setProjectManagers(this.getProjectManagers(beanClass, relationships));
                    bean.setProjectTeam(this.getProjectTeam(beanClass, relationships));
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    protected ProjectProperties getProjectProperties(OpenMetadataElement primaryElement) {
        if (primaryElement.getElementProperties() != null) {
            ElementProperties elementProperties = new ElementProperties(primaryElement.getElementProperties());
            ProjectProperties projectProperties = new ProjectProperties();
            projectProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
            projectProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
            projectProperties.setIdentifier(this.removeIdentifier(elementProperties));
            projectProperties.setName(this.removeName(elementProperties));
            projectProperties.setDescription(this.removeDescription(elementProperties));
            projectProperties.setProjectStatus(this.removeProjectStatus(elementProperties));
            projectProperties.setStartDate(this.removeStartDate(elementProperties));
            projectProperties.setPlannedEndDate(this.removePlannedEndDate(elementProperties));
            projectProperties.setEffectiveFrom(primaryElement.getEffectiveFromTime());
            projectProperties.setEffectiveTo(primaryElement.getEffectiveToTime());
            projectProperties.setTypeName(primaryElement.getType().getTypeName());
            projectProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
            return projectProperties;
        }
        return null;
    }

    protected List<RelatedMetadataElementSummary> getResourceList(Class<B> beanClass, List<RelatedMetadataElement> resourceListElements) throws PropertyServerException {
        String methodName = "getResourceList";
        if (resourceListElements != null) {
            ArrayList<RelatedMetadataElementSummary> resourceList = new ArrayList<RelatedMetadataElementSummary>();
            for (RelatedMetadataElement resourceListElement : resourceListElements) {
                if (resourceListElement == null || !this.propertyHelper.isTypeOf(resourceListElement, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName)) continue;
                resourceList.add(super.getRelatedElementSummary(beanClass, resourceListElement, "getResourceList"));
            }
            return resourceList;
        }
        return null;
    }

    protected List<RelatedMetadataElementSummary> getProjectManagers(Class<B> beanClass, List<RelatedMetadataElement> projectManagerElements) throws PropertyServerException {
        String methodName = "getProjectManagers";
        if (projectManagerElements != null) {
            ArrayList<RelatedMetadataElementSummary> projectManagers = new ArrayList<RelatedMetadataElementSummary>();
            for (RelatedMetadataElement projectManagerElement : projectManagerElements) {
                if (projectManagerElement == null || !this.propertyHelper.isTypeOf(projectManagerElement, OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeName)) continue;
                projectManagers.add(super.getRelatedElementSummary(beanClass, projectManagerElement, "getProjectManagers"));
            }
            return projectManagers;
        }
        return null;
    }

    protected List<RelatedMetadataElementSummary> getProjectTeam(Class<B> beanClass, List<RelatedMetadataElement> projectTeamElements) throws PropertyServerException {
        String methodName = "getProjectTeam";
        if (projectTeamElements != null) {
            ArrayList<RelatedMetadataElementSummary> projectTeam = new ArrayList<RelatedMetadataElementSummary>();
            for (RelatedMetadataElement projectTeamElement : projectTeamElements) {
                if (projectTeamElement == null || !this.propertyHelper.isTypeOf(projectTeamElement, OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.typeName)) continue;
                projectTeam.add(super.getRelatedElementSummary(beanClass, projectTeamElement, "getProjectTeam"));
            }
            return projectTeam;
        }
        return null;
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, RelatedMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ProjectElement) {
                ProjectElement bean = (ProjectElement)returnBean;
                ProjectProperties projectProperties = new ProjectProperties();
                OpenMetadataElement openMetadataElement = primaryElement.getElement();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, openMetadataElement, methodName));
                if (openMetadataElement != null) {
                    ElementProperties elementProperties = new ElementProperties(openMetadataElement.getElementProperties());
                    projectProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
                    projectProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
                    projectProperties.setIdentifier(this.removeIdentifier(elementProperties));
                    projectProperties.setName(this.removeName(elementProperties));
                    projectProperties.setDescription(this.removeDescription(elementProperties));
                    projectProperties.setProjectStatus(this.removeProjectStatus(elementProperties));
                    projectProperties.setProjectHealth(this.removeProjectHealth(elementProperties));
                    projectProperties.setProjectPhase(this.removeProjectPhase(elementProperties));
                    projectProperties.setPriority(this.removeIntPriority(elementProperties));
                    projectProperties.setStartDate(this.removeStartDate(elementProperties));
                    projectProperties.setPlannedEndDate(this.removePlannedEndDate(elementProperties));
                    projectProperties.setEffectiveFrom(openMetadataElement.getEffectiveFromTime());
                    projectProperties.setEffectiveTo(openMetadataElement.getEffectiveToTime());
                    projectProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    projectProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                if (relationships != null) {
                    bean.setResourceList(this.getResourceList(beanClass, relationships));
                    bean.setProjectManagers(this.getProjectManagers(beanClass, relationships));
                    bean.setProjectTeam(this.getProjectTeam(beanClass, relationships));
                }
                bean.setProperties(projectProperties);
                bean.setRelatedBy(super.getRelatedBy(beanClass, primaryElement, methodName));
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

