/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SolutionBlueprintComponent;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SolutionBlueprintElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.solutions.SolutionBlueprintProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;

public class SolutionBlueprintConverter<B>
extends OpenMetadataConverterBase<B> {
    private final List<SolutionBlueprintComponent> solutionComponentElements;

    public SolutionBlueprintConverter(PropertyHelper propertyHelper, String serviceName, String serverName, List<SolutionBlueprintComponent> solutionComponentElements) {
        super(propertyHelper, serviceName, serverName);
        this.solutionComponentElements = solutionComponentElements;
    }

    @Override
    public B getNewBean(Class<B> beanClass, OpenMetadataElement primaryElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof SolutionBlueprintElement) {
                SolutionBlueprintElement bean = (SolutionBlueprintElement)returnBean;
                SolutionBlueprintProperties solutionBlueprintProperties = new SolutionBlueprintProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                bean.setSolutionComponents(this.solutionComponentElements);
                if (primaryElement != null) {
                    ElementProperties elementProperties = new ElementProperties(primaryElement.getElementProperties());
                    solutionBlueprintProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
                    solutionBlueprintProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
                    solutionBlueprintProperties.setDisplayName(this.removeDisplayName(elementProperties));
                    solutionBlueprintProperties.setDescription(this.removeDescription(elementProperties));
                    solutionBlueprintProperties.setVersion(this.removeVersionIdentifier(elementProperties));
                    solutionBlueprintProperties.setEffectiveFrom(primaryElement.getEffectiveFromTime());
                    solutionBlueprintProperties.setEffectiveTo(primaryElement.getEffectiveToTime());
                    solutionBlueprintProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    solutionBlueprintProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                    bean.setProperties(solutionBlueprintProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                bean.setProperties(solutionBlueprintProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

