/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SolutionComponentElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SolutionPortElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.WiredSolutionComponent;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.solutions.SolutionComponentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.solutions.SolutionLinkingWireProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class SolutionComponentConverter<B>
extends OpenMetadataConverterBase<B> {
    private final List<SolutionComponentElement> subComponents;
    private final List<SolutionPortElement> ports;

    public SolutionComponentConverter(PropertyHelper propertyHelper, String serviceName, String serverName, List<SolutionComponentElement> subComponents, List<SolutionPortElement> ports) {
        super(propertyHelper, serviceName, serverName);
        this.subComponents = subComponents;
        this.ports = ports;
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, OpenMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof SolutionComponentElement) {
                SolutionComponentElement bean = (SolutionComponentElement)returnBean;
                SolutionComponentProperties solutionComponentProperties = new SolutionComponentProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                bean.setSubComponents(this.subComponents);
                bean.setPorts(this.ports);
                if (primaryElement != null) {
                    ElementProperties elementProperties = new ElementProperties(primaryElement.getElementProperties());
                    solutionComponentProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
                    solutionComponentProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
                    solutionComponentProperties.setDisplayName(this.removeDisplayName(elementProperties));
                    solutionComponentProperties.setDescription(this.removeDescription(elementProperties));
                    solutionComponentProperties.setVersion(this.removeVersionIdentifier(elementProperties));
                    solutionComponentProperties.setSolutionComponentType(this.removeSolutionComponentType(elementProperties));
                    solutionComponentProperties.setPlannedDeployedImplementationType(this.removeDeployedImplementationType(elementProperties));
                    solutionComponentProperties.setEffectiveFrom(primaryElement.getEffectiveFromTime());
                    solutionComponentProperties.setEffectiveTo(primaryElement.getEffectiveToTime());
                    solutionComponentProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    solutionComponentProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                    bean.setProperties(solutionComponentProperties);
                    if (relationships != null) {
                        ArrayList<WiredSolutionComponent> wiredFrom = new ArrayList<WiredSolutionComponent>();
                        ArrayList<WiredSolutionComponent> wiredTo = new ArrayList<WiredSolutionComponent>();
                        ArrayList<RelatedMetadataElementSummary> actors = new ArrayList<RelatedMetadataElementSummary>();
                        ArrayList<RelatedMetadataElementSummary> blueprints = new ArrayList<RelatedMetadataElementSummary>();
                        ArrayList<RelatedMetadataElementSummary> implementations = new ArrayList<RelatedMetadataElementSummary>();
                        ArrayList<RelatedMetadataElementSummary> otherElements = new ArrayList<RelatedMetadataElementSummary>();
                        for (RelatedMetadataElement relatedMetadataElement : relationships) {
                            if (relatedMetadataElement == null) continue;
                            if (this.propertyHelper.isTypeOf(relatedMetadataElement, OpenMetadataType.SOLUTION_COMPONENT_ACTOR_RELATIONSHIP.typeName)) {
                                actors.add(super.getRelatedElementSummary(beanClass, relatedMetadataElement, methodName));
                                continue;
                            }
                            if (this.propertyHelper.isTypeOf(relatedMetadataElement, OpenMetadataType.SOLUTION_BLUEPRINT_COMPOSITION_RELATIONSHIP.typeName)) {
                                blueprints.add(super.getRelatedElementSummary(beanClass, relatedMetadataElement, methodName));
                                continue;
                            }
                            if (this.propertyHelper.isTypeOf(relatedMetadataElement, OpenMetadataType.IMPLEMENTED_BY_RELATIONSHIP.typeName)) {
                                implementations.add(super.getRelatedElementSummary(beanClass, relatedMetadataElement, methodName));
                                continue;
                            }
                            if (this.propertyHelper.isTypeOf(relatedMetadataElement, OpenMetadataType.SOLUTION_LINKING_WIRE_RELATIONSHIP.typeName)) {
                                WiredSolutionComponent link = new WiredSolutionComponent();
                                SolutionLinkingWireProperties solutionLinkingWireProperties = new SolutionLinkingWireProperties();
                                link.setElementHeader(super.getMetadataElementHeader(beanClass, relatedMetadataElement, relatedMetadataElement.getRelationshipGUID(), null, methodName));
                                elementProperties = new ElementProperties(relatedMetadataElement.getRelationshipProperties());
                                solutionLinkingWireProperties.setLabel(this.removeLabel(elementProperties));
                                solutionLinkingWireProperties.setDescription(this.removeDescription(elementProperties));
                                solutionLinkingWireProperties.setInformationSupplyChainSegmentGUIDs(this.removeInformationSupplyChainSegmentGUIDs(elementProperties));
                                solutionLinkingWireProperties.setEffectiveFrom(primaryElement.getEffectiveFromTime());
                                solutionLinkingWireProperties.setEffectiveTo(primaryElement.getEffectiveToTime());
                                solutionLinkingWireProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                                link.setProperties(solutionLinkingWireProperties);
                                link.setLinkedElement(super.getElementSummary(beanClass, relatedMetadataElement.getElement(), methodName));
                                if (relatedMetadataElement.getElementAtEnd1()) {
                                    wiredTo.add(link);
                                    continue;
                                }
                                wiredFrom.add(link);
                                continue;
                            }
                            otherElements.add(super.getRelatedElementSummary(beanClass, relatedMetadataElement, methodName));
                        }
                        if (!wiredFrom.isEmpty()) {
                            bean.setWiredFromLinks(wiredFrom);
                        }
                        if (!wiredTo.isEmpty()) {
                            bean.setWiredToLinks(wiredTo);
                        }
                        if (!actors.isEmpty()) {
                            bean.setActors(actors);
                        }
                        if (!blueprints.isEmpty()) {
                            bean.setBlueprints(blueprints);
                        }
                        if (!implementations.isEmpty()) {
                            bean.setImplementations(implementations);
                        }
                        if (!otherElements.isEmpty()) {
                            bean.setOtherElements(otherElements);
                        }
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                bean.setProperties(solutionComponentProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

