/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum AnnotationStatus implements OpenMetadataEnum
{
    NEW_ANNOTATION(0, "4a4cd94d-e407-4218-9d5b-fbc1a68a2d37", "New", "Annotation has been created but not reviewed", false),
    REVIEWED_ANNOTATION(1, "273cb963-2145-470a-9040-7634c8f30f0b", "Reviewed", "Annotation has been reviewed by no decision has been made", false),
    APPROVED_ANNOTATION(2, "c5447bdb-d1dc-4d6a-811b-b98845ca19da", "Approved", "Annotation has been approved", false),
    ACTIONED_ANNOTATION(3, "f561ac14-d6ea-44d7-a432-8f0dd2e40123", "Actioned", "Annotation has been approved and insight has been added to Asset's metadata", false),
    INVALID_ANNOTATION(4, "6b9bc674-24ce-466f-8647-a2a303813341", "Invalid", "Annotation has been reviewed and declared invalid", false),
    IGNORE_ANNOTATION(5, "90949088-ca0f-4bd9-9936-ee6b343f5e94", "Ignore", "Annotation is invalid and should be ignored", false),
    OTHER_STATUS(98, "e16ec89e-f2af-4b63-bbac-a286ffdba771", "Other", "Annotation's status stored in additional properties", false),
    UNKNOWN_STATUS(99, "691a566f-27a7-4106-817a-9f04fad870ab", "Unknown", "Annotation has not had a status assigned", false);

    private static final String ENUM_TYPE_GUID = "71187df6-ef66-4f88-bc03-cd3c7f925165";
    private static final String ENUM_TYPE_NAME = "AnnotationStatus";
    private static final String ENUM_DESCRIPTION = "Defines the status of an annotation.";
    private static final String ENUM_DESCRIPTION_GUID = "a2671bf6-5eef-4432-a189-1e99d84507e1";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/6/0612-Annotation-Reviews/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private AnnotationStatus(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String toString() {
        return "AnnotationStatus : " + this.name;
    }
}

