/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum DataItemSortOrder implements OpenMetadataEnum
{
    ASCENDING(0, "f940039e-eced-411e-b013-daf683780fc8", "Ascending", "The attribute instances are organized so that the smallest/lowest value is first and the rest of the instances follow in ascending order.", false),
    DESCENDING(1, "371e7314-d772-4c1c-a289-0b45e98d7b16", "Descending", "The attribute instances are organized so that the largest/highest value is first and the rest of the instances follow in descending order.", false),
    UNSORTED(99, "8d7bcad1-f779-4563-8c32-d35b26b9eb1c", "Unsorted", "The instances of the schema attribute may appear in any order.", true);

    private static final String ENUM_TYPE_GUID = "aaa4df8f-1aca-4de8-9abd-1ef2aadba300";
    private static final String ENUM_TYPE_NAME = "DataItemSortOrder";
    private static final String ENUM_DESCRIPTION = "Defines the suggested order that data values in this data item should be sorted by.";
    private static final String ENUM_DESCRIPTION_GUID = "3ad77990-beda-4877-b5ae-5368c372cab6";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/5/0505-Schema-Attributes/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private DataItemSortOrder(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.SORT_ORDER.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.SORT_ORDER.name, null);
    }

    public String toString() {
        return "DataItemSortOrder{name='" + this.name + "}";
    }
}

