/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum SolutionPortDirection implements OpenMetadataEnum
{
    UNKNOWN("29454899-dd9b-4855-8846-f7f1bb05e5d3", 0, "Unknown", "The direction of flow is unknown."),
    INPUT("d0148bd8-5240-4262-9181-c2e343111d79", 2, "Input", "Data is passed into the solution component."),
    OUTPUT("ba93f0c5-e502-4a19-a1dd-0fda01dbe54c", 1, "Output", "Data is produced by the solution component."),
    INOUT("c9db81ce-6c98-480f-bf49-c05a13a832ca", 3, "Input-Output", "A request response interface is provided by the solution component."),
    OUTIN("9e1339d2-92a5-41a3-9aed-8b0bd66a4a75", 4, "Output-Input", "A request response call is made by the solution component."),
    OTHER("a6b3233b-b38f-47ad-82aa-f8eb1748b946", 99, "Other", "None of the above.");

    private static final String ENUM_TYPE_GUID = "4879c96e-26c7-48af-ba92-8277632be733";
    private static final String ENUM_TYPE_NAME = "SolutionPortDirection";
    private static final String ENUM_DESCRIPTION = "Descriptor for a solution port that indicates the direction that data is flowing.";
    private static final String ENUM_DESCRIPTION_GUID = "cad833b8-4619-49f1-a28a-e6a60f38ef4f";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/7/0735-Solution-Ports-and-Wires/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;

    private SolutionPortDirection(String descriptionGUID, int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.DIRECTION.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.DIRECTION.name, null);
    }

    public String toString() {
        return "PortType{" + this.name + "}";
    }
}

