/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Appointee
implements MetadataElement {
    private ElementHeader elementHeader = null;
    private ActorProfileElement profile = null;
    private Date startDate = null;
    private Date endDate = null;
    private boolean isPublic = false;

    public Appointee() {
    }

    public Appointee(Appointee template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.profile = template.getProfile();
            this.startDate = template.getStartDate();
            this.endDate = template.getEndDate();
            this.isPublic = template.getIsPublic();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public boolean getIsPublic() {
        return this.isPublic;
    }

    public void setIsPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public ActorProfileElement getProfile() {
        return this.profile;
    }

    public void setProfile(ActorProfileElement profile) {
        this.profile = profile;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String toString() {
        return "Appointee{elementHeader=" + String.valueOf(this.elementHeader) + ", profile=" + String.valueOf(this.profile) + ", startDate=" + String.valueOf(this.startDate) + ", endDate=" + String.valueOf(this.endDate) + ", isPublic=" + this.isPublic + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        Appointee appointee = (Appointee)objectToCompare;
        return this.isPublic == appointee.isPublic && Objects.equals(this.elementHeader, appointee.elementHeader) && Objects.equals(this.profile, appointee.profile) && Objects.equals(this.startDate, appointee.startDate) && Objects.equals(this.endDate, appointee.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.getProfile(), this.getElementHeader(), this.getStartDate(), this.getEndDate(), this.getIsPublic());
    }
}

