/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AttributedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MemberDataField;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries.DataStructureProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataStructureElement
extends AttributedMetadataElement {
    private DataStructureProperties properties = null;
    private List<MemberDataField> memberDataFields = null;
    private RelatedMetadataElementSummary equivalentSchemaType = null;
    private List<RelatedMetadataElementSummary> memberOfCollections = null;

    public DataStructureElement() {
    }

    public DataStructureElement(DataStructureElement template) {
        super(template);
        if (template != null) {
            this.properties = template.getProperties();
            this.memberDataFields = template.getMemberDataFields();
            this.equivalentSchemaType = template.getEquivalentSchemaType();
            this.memberOfCollections = template.getMemberOfCollections();
        }
    }

    public DataStructureProperties getProperties() {
        return this.properties;
    }

    public void setProperties(DataStructureProperties properties) {
        this.properties = properties;
    }

    public List<MemberDataField> getMemberDataFields() {
        return this.memberDataFields;
    }

    public void setMemberDataFields(List<MemberDataField> memberDataFields) {
        this.memberDataFields = memberDataFields;
    }

    public RelatedMetadataElementSummary getEquivalentSchemaType() {
        return this.equivalentSchemaType;
    }

    public void setEquivalentSchemaType(RelatedMetadataElementSummary equivalentSchemaType) {
        this.equivalentSchemaType = equivalentSchemaType;
    }

    public List<RelatedMetadataElementSummary> getMemberOfCollections() {
        return this.memberOfCollections;
    }

    public void setMemberOfCollections(List<RelatedMetadataElementSummary> memberOfCollections) {
        this.memberOfCollections = memberOfCollections;
    }

    @Override
    public String toString() {
        return "DataStructureElement{properties=" + String.valueOf(this.properties) + ", memberDataFields=" + String.valueOf(this.memberDataFields) + ", equivalentSchemaType=" + String.valueOf(this.equivalentSchemaType) + ", memberOfCollections=" + String.valueOf(this.memberOfCollections) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataStructureElement that = (DataStructureElement)objectToCompare;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.memberDataFields, that.memberDataFields) && Objects.equals(this.equivalentSchemaType, that.equivalentSchemaType) && Objects.equals(this.memberOfCollections, that.memberDataFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.properties, this.memberDataFields, this.equivalentSchemaType, this.memberOfCollections);
    }
}

