/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.databases.DatabaseProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DatabaseElement
implements MetadataElement {
    private ElementHeader elementHeader = null;
    private DatabaseProperties databaseProperties = null;

    public DatabaseElement() {
    }

    public DatabaseElement(DatabaseElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.databaseProperties = template.getDatabaseProperties();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public DatabaseProperties getDatabaseProperties() {
        return this.databaseProperties;
    }

    public void setDatabaseProperties(DatabaseProperties databaseProperties) {
        this.databaseProperties = databaseProperties;
    }

    public String toString() {
        return "DatabaseElement{elementHeader=" + String.valueOf(this.elementHeader) + ", databaseProperties=" + String.valueOf(this.databaseProperties) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        DatabaseElement that = (DatabaseElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.databaseProperties, that.databaseProperties);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.databaseProperties);
    }
}

