/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AttributedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CorrelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryCategoryProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GlossaryCategoryElement
extends AttributedMetadataElement
implements CorrelatedMetadataElement {
    private List<MetadataCorrelationHeader> correlationHeaders = null;
    private GlossaryCategoryProperties glossaryCategoryProperties = null;
    private RelatedMetadataElementSummary parentGlossary = null;
    private RelatedMetadataElementSummary parentCategory = null;
    private List<RelatedMetadataElementSummary> childCategories = null;
    private List<RelatedMetadataElementSummary> terms = null;

    public GlossaryCategoryElement() {
    }

    public GlossaryCategoryElement(GlossaryCategoryElement template) {
        super(template);
        if (template != null) {
            this.correlationHeaders = template.getCorrelationHeaders();
            this.glossaryCategoryProperties = template.getGlossaryCategoryProperties();
            this.parentGlossary = template.getParentGlossary();
            this.parentCategory = template.getParentCategory();
            this.childCategories = template.getChildCategories();
            this.terms = template.getTerms();
        }
    }

    @Override
    public List<MetadataCorrelationHeader> getCorrelationHeaders() {
        return this.correlationHeaders;
    }

    @Override
    public void setCorrelationHeaders(List<MetadataCorrelationHeader> correlationHeaders) {
        this.correlationHeaders = correlationHeaders;
    }

    public GlossaryCategoryProperties getGlossaryCategoryProperties() {
        return this.glossaryCategoryProperties;
    }

    public void setGlossaryCategoryProperties(GlossaryCategoryProperties glossaryCategoryProperties) {
        this.glossaryCategoryProperties = glossaryCategoryProperties;
    }

    public RelatedMetadataElementSummary getParentGlossary() {
        return this.parentGlossary;
    }

    public void setParentGlossary(RelatedMetadataElementSummary parentGlossary) {
        this.parentGlossary = parentGlossary;
    }

    public RelatedMetadataElementSummary getParentCategory() {
        return this.parentCategory;
    }

    public void setParentCategory(RelatedMetadataElementSummary parentCategory) {
        this.parentCategory = parentCategory;
    }

    public List<RelatedMetadataElementSummary> getChildCategories() {
        return this.childCategories;
    }

    public void setChildCategories(List<RelatedMetadataElementSummary> childCategories) {
        this.childCategories = childCategories;
    }

    public List<RelatedMetadataElementSummary> getTerms() {
        return this.terms;
    }

    public void setTerms(List<RelatedMetadataElementSummary> terms) {
        this.terms = terms;
    }

    @Override
    public String toString() {
        return "GlossaryCategoryElement{correlationHeaders=" + String.valueOf(this.correlationHeaders) + ", glossaryCategoryProperties=" + String.valueOf(this.glossaryCategoryProperties) + ", parentGlossary=" + String.valueOf(this.parentGlossary) + ", parentCategory=" + String.valueOf(this.parentCategory) + ", childCategories=" + String.valueOf(this.childCategories) + ", terms=" + String.valueOf(this.terms) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GlossaryCategoryElement that = (GlossaryCategoryElement)objectToCompare;
        return Objects.equals(this.correlationHeaders, that.correlationHeaders) && Objects.equals(this.glossaryCategoryProperties, that.glossaryCategoryProperties) && Objects.equals(this.parentGlossary, that.parentGlossary) && Objects.equals(this.parentCategory, that.parentCategory) && Objects.equals(this.childCategories, that.childCategories) && Objects.equals(this.terms, that.terms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.correlationHeaders, this.glossaryCategoryProperties, this.parentGlossary, this.parentCategory, this.childCategories, this.terms);
    }
}

