/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AttributedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ChildCategoryElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CorrelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GlossaryElement
extends AttributedMetadataElement
implements CorrelatedMetadataElement {
    private List<MetadataCorrelationHeader> correlationHeaders = null;
    private GlossaryProperties glossaryProperties = null;
    private List<ChildCategoryElement> categories = null;

    public GlossaryElement() {
    }

    public GlossaryElement(GlossaryElement template) {
        super(template);
        if (template != null) {
            this.correlationHeaders = template.getCorrelationHeaders();
            this.glossaryProperties = template.getGlossaryProperties();
            this.categories = template.getCategories();
        }
    }

    @Override
    public List<MetadataCorrelationHeader> getCorrelationHeaders() {
        return this.correlationHeaders;
    }

    @Override
    public void setCorrelationHeaders(List<MetadataCorrelationHeader> correlationHeaders) {
        this.correlationHeaders = correlationHeaders;
    }

    public GlossaryProperties getGlossaryProperties() {
        return this.glossaryProperties;
    }

    public void setGlossaryProperties(GlossaryProperties glossaryProperties) {
        this.glossaryProperties = glossaryProperties;
    }

    public List<ChildCategoryElement> getCategories() {
        return this.categories;
    }

    public void setCategories(List<ChildCategoryElement> categories) {
        this.categories = categories;
    }

    @Override
    public String toString() {
        return "GlossaryElement{correlationHeaders=" + String.valueOf(this.correlationHeaders) + ", glossaryProperties=" + String.valueOf(this.glossaryProperties) + ", categories=" + String.valueOf(this.categories) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GlossaryElement that = (GlossaryElement)objectToCompare;
        return Objects.equals(this.correlationHeaders, that.correlationHeaders) && Objects.equals(this.glossaryProperties, that.glossaryProperties) && Objects.equals(this.categories, that.categories);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.correlationHeaders, this.glossaryProperties, this.categories);
    }
}

