/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedBy;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.ProjectProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectElement
implements MetadataElement {
    private ElementHeader elementHeader = null;
    private ProjectProperties properties = null;
    private RelatedBy relatedBy = null;
    private List<RelatedMetadataElementSummary> resourceList = null;
    private List<RelatedMetadataElementSummary> projectManagers = null;
    private List<RelatedMetadataElementSummary> projectTeam = null;
    protected String mermaidGraph = null;

    public ProjectElement() {
    }

    public ProjectElement(ProjectElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.properties = template.getProperties();
            this.relatedBy = template.getRelatedBy();
            this.resourceList = template.getResourceList();
            this.projectManagers = template.getProjectManagers();
            this.projectTeam = template.getProjectTeam();
            this.mermaidGraph = template.getMermaidGraph();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public ProjectProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ProjectProperties properties) {
        this.properties = properties;
    }

    public RelatedBy getRelatedBy() {
        return this.relatedBy;
    }

    public void setRelatedBy(RelatedBy relatedBy) {
        this.relatedBy = relatedBy;
    }

    public List<RelatedMetadataElementSummary> getResourceList() {
        return this.resourceList;
    }

    public void setResourceList(List<RelatedMetadataElementSummary> resourceList) {
        this.resourceList = resourceList;
    }

    public List<RelatedMetadataElementSummary> getProjectManagers() {
        return this.projectManagers;
    }

    public void setProjectManagers(List<RelatedMetadataElementSummary> projectManagers) {
        this.projectManagers = projectManagers;
    }

    public List<RelatedMetadataElementSummary> getProjectTeam() {
        return this.projectTeam;
    }

    public void setProjectTeam(List<RelatedMetadataElementSummary> projectTeam) {
        this.projectTeam = projectTeam;
    }

    public String getMermaidGraph() {
        return this.mermaidGraph;
    }

    public void setMermaidGraph(String mermaidGraph) {
        this.mermaidGraph = mermaidGraph;
    }

    public String toString() {
        return "ProjectElement{elementHeader=" + String.valueOf(this.elementHeader) + ", properties=" + String.valueOf(this.properties) + ", relatedBy=" + String.valueOf(this.relatedBy) + ", resourceList=" + String.valueOf(this.resourceList) + ", projectManagers=" + String.valueOf(this.projectManagers) + ", projectTeam=" + String.valueOf(this.projectTeam) + ", mermaidGraph='" + this.mermaidGraph + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ProjectElement that = (ProjectElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.properties, that.properties) && Objects.equals(this.resourceList, that.resourceList) && Objects.equals(this.projectManagers, that.projectManagers) && Objects.equals(this.projectTeam, that.projectTeam) && Objects.equals(this.relatedBy, that.relatedBy) && Objects.equals(this.mermaidGraph, that.mermaidGraph);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.properties, this.relatedBy, this.resourceList, this.projectManagers, this.projectTeam, this.mermaidGraph);
    }
}

