/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProjectElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectHierarchy
extends ProjectElement {
    private List<RelatedMetadataElementSummary> dependentProjects = null;
    private List<RelatedMetadataElementSummary> dependsOnProjects = null;
    private List<ProjectHierarchy> children = null;

    public ProjectHierarchy() {
    }

    public ProjectHierarchy(ProjectHierarchy template) {
        super(template);
        if (template != null) {
            this.dependsOnProjects = template.getDependsOnProjects();
            this.dependentProjects = template.getDependentProjects();
            this.children = template.getChildren();
        }
    }

    public ProjectHierarchy(ProjectElement template) {
        super(template);
    }

    public List<RelatedMetadataElementSummary> getDependentProjects() {
        return this.dependentProjects;
    }

    public void setDependentProjects(List<RelatedMetadataElementSummary> dependentProjects) {
        this.dependentProjects = dependentProjects;
    }

    public List<RelatedMetadataElementSummary> getDependsOnProjects() {
        return this.dependsOnProjects;
    }

    public void setDependsOnProjects(List<RelatedMetadataElementSummary> dependsOnProjects) {
        this.dependsOnProjects = dependsOnProjects;
    }

    public List<ProjectHierarchy> getChildren() {
        return this.children;
    }

    public void setChildren(List<ProjectHierarchy> children) {
        this.children = children;
    }

    @Override
    public String toString() {
        return "ProjectHierarchy{dependentProjects=" + String.valueOf(this.dependentProjects) + ", dependsOnProjects=" + String.valueOf(this.dependsOnProjects) + ", children=" + String.valueOf(this.children) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ProjectHierarchy)) {
            return false;
        }
        ProjectHierarchy that = (ProjectHierarchy)objectToCompare;
        if (!super.equals(objectToCompare)) {
            return false;
        }
        return Objects.equals(this.dependsOnProjects, that.dependsOnProjects) && Objects.equals(this.dependentProjects, that.dependentProjects) && Objects.equals(this.children, that.children);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dependsOnProjects, this.dependentProjects, this.children);
    }
}

