/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RelatedAssetElement
implements MetadataElement {
    private ElementHeader elementHeader = null;
    private Map<String, Object> properties = null;
    private Date effectiveFrom = null;
    private Date effectiveTo = null;
    private AssetElement relatedAsset = null;

    public RelatedAssetElement() {
    }

    public RelatedAssetElement(RelatedAssetElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.properties = template.getProperties();
            this.relatedAsset = template.getRelatedAsset();
            this.effectiveFrom = template.getEffectiveFrom();
            this.effectiveTo = template.getEffectiveTo();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Date getEffectiveFrom() {
        return this.effectiveFrom;
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.effectiveFrom = effectiveFrom;
    }

    public Date getEffectiveTo() {
        return this.effectiveTo;
    }

    public void setEffectiveTo(Date effectiveTo) {
        this.effectiveTo = effectiveTo;
    }

    public AssetElement getRelatedAsset() {
        return this.relatedAsset;
    }

    public void setRelatedAsset(AssetElement relatedAsset) {
        this.relatedAsset = relatedAsset;
    }

    public String toString() {
        return "RelatedAssetElement{elementHeader=" + String.valueOf(this.elementHeader) + ", properties=" + String.valueOf(this.properties) + ", effectiveFrom=" + String.valueOf(this.effectiveFrom) + ", effectiveTo=" + String.valueOf(this.effectiveTo) + ", relatedAsset=" + String.valueOf(this.relatedAsset) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        RelatedAssetElement that = (RelatedAssetElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.properties, that.properties) && Objects.equals(this.effectiveFrom, that.effectiveFrom) && Objects.equals(this.effectiveTo, that.effectiveTo) && Objects.equals(this.relatedAsset, that.relatedAsset);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.properties, this.effectiveFrom, this.effectiveTo, this.relatedAsset);
    }
}

