/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.DerivedSchemaTypeQueryTargetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaTypeProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaTypeElement
implements MetadataElement {
    private SchemaTypeProperties schemaTypeProperties = null;
    private ElementHeader elementHeader = null;
    private int attributeCount = 0;
    private SchemaTypeElement mapFromElement = null;
    private SchemaTypeElement mapToElement = null;
    private SchemaTypeElement externalSchemaType = null;
    private List<SchemaTypeElement> schemaOptions = null;
    private String formula = null;
    private String formulaType = null;
    private List<DerivedSchemaTypeQueryTargetProperties> queries = null;

    public SchemaTypeElement() {
    }

    public SchemaTypeElement(SchemaTypeElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.schemaTypeProperties = template.getSchemaTypeProperties();
            this.attributeCount = template.getAttributeCount();
            this.mapFromElement = template.getMapFromElement();
            this.mapToElement = template.getMapToElement();
            this.externalSchemaType = template.getExternalSchemaType();
            this.schemaOptions = template.getSchemaOptions();
            this.formula = template.getFormula();
            this.formulaType = template.getFormulaType();
            this.queries = template.getQueries();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public SchemaTypeProperties getSchemaTypeProperties() {
        return this.schemaTypeProperties;
    }

    public void setSchemaTypeProperties(SchemaTypeProperties schemaTypeProperties) {
        this.schemaTypeProperties = schemaTypeProperties;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public void setAttributeCount(int attributeCount) {
        this.attributeCount = attributeCount;
    }

    public SchemaTypeElement getMapFromElement() {
        return this.mapFromElement;
    }

    public void setMapFromElement(SchemaTypeElement mapFromElement) {
        this.mapFromElement = mapFromElement;
    }

    public SchemaTypeElement getMapToElement() {
        return this.mapToElement;
    }

    public void setMapToElement(SchemaTypeElement mapToElement) {
        this.mapToElement = mapToElement;
    }

    public SchemaTypeElement getExternalSchemaType() {
        return this.externalSchemaType;
    }

    public void setExternalSchemaType(SchemaTypeElement externalSchemaType) {
        this.externalSchemaType = externalSchemaType;
    }

    public List<SchemaTypeElement> getSchemaOptions() {
        if (this.schemaOptions == null) {
            return null;
        }
        if (this.schemaOptions.isEmpty()) {
            return null;
        }
        return this.schemaOptions;
    }

    public void setSchemaOptions(List<SchemaTypeElement> schemaOptions) {
        this.schemaOptions = schemaOptions;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getFormulaType() {
        return this.formulaType;
    }

    public void setFormulaType(String formulaType) {
        this.formulaType = formulaType;
    }

    public List<DerivedSchemaTypeQueryTargetProperties> getQueries() {
        return this.queries;
    }

    public void setQueries(List<DerivedSchemaTypeQueryTargetProperties> queries) {
        this.queries = queries;
    }

    public String toString() {
        return "SchemaTypeElement{schemaTypeProperties=" + String.valueOf(this.schemaTypeProperties) + ", elementHeader=" + String.valueOf(this.elementHeader) + ", attributeCount=" + this.attributeCount + ", mapFromElement=" + String.valueOf(this.mapFromElement) + ", mapToElement=" + String.valueOf(this.mapToElement) + ", formula='" + this.formula + "', formulaType='" + this.formulaType + "', queries=" + String.valueOf(this.queries) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        SchemaTypeElement that = (SchemaTypeElement)objectToCompare;
        return this.attributeCount == that.attributeCount && Objects.equals(this.schemaTypeProperties, that.schemaTypeProperties) && Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.mapFromElement, that.mapFromElement) && Objects.equals(this.mapToElement, that.mapToElement) && Objects.equals(this.externalSchemaType, that.externalSchemaType) && Objects.equals(this.schemaOptions, that.schemaOptions) && Objects.equals(this.formula, that.formula) && Objects.equals(this.formulaType, that.formulaType) && Objects.equals(this.queries, that.queries);
    }

    public int hashCode() {
        return Objects.hash(this.schemaTypeProperties, this.elementHeader, this.attributeCount, this.mapFromElement, this.mapToElement, this.externalSchemaType, this.schemaOptions, this.formula, this.formulaType, this.queries);
    }
}

