/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SubjectAreaProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubjectAreaElement
implements MetadataElement {
    private ElementHeader elementHeader = null;
    private SubjectAreaProperties properties = null;
    private String parentSubjectAreaGUID = null;
    private List<String> nestedSubjectAreaGUIDs = null;
    private List<ElementStub> associatedGovernanceDefinitions = null;

    public SubjectAreaElement() {
    }

    public SubjectAreaElement(SubjectAreaElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.properties = template.getProperties();
            this.parentSubjectAreaGUID = template.getParentSubjectAreaGUID();
            this.nestedSubjectAreaGUIDs = template.getNestedSubjectAreaGUIDs();
            this.associatedGovernanceDefinitions = template.getAssociatedGovernanceDefinitions();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public SubjectAreaProperties getProperties() {
        return this.properties;
    }

    public void setProperties(SubjectAreaProperties properties) {
        this.properties = properties;
    }

    public String getParentSubjectAreaGUID() {
        return this.parentSubjectAreaGUID;
    }

    public void setParentSubjectAreaGUID(String parentSubjectAreaGUID) {
        this.parentSubjectAreaGUID = parentSubjectAreaGUID;
    }

    public List<String> getNestedSubjectAreaGUIDs() {
        return this.nestedSubjectAreaGUIDs;
    }

    public void setNestedSubjectAreaGUIDs(List<String> nestedSubjectAreaGUIDs) {
        this.nestedSubjectAreaGUIDs = nestedSubjectAreaGUIDs;
    }

    public List<ElementStub> getAssociatedGovernanceDefinitions() {
        return this.associatedGovernanceDefinitions;
    }

    public void setAssociatedGovernanceDefinitions(List<ElementStub> associatedGovernanceDefinitions) {
        this.associatedGovernanceDefinitions = associatedGovernanceDefinitions;
    }

    public String toString() {
        return "SubjectAreaElement{elementHeader=" + String.valueOf(this.elementHeader) + ", properties=" + String.valueOf(this.properties) + ", parentSubjectAreaGUID='" + this.parentSubjectAreaGUID + "', nestedSubjectAreaGUIDs=" + String.valueOf(this.nestedSubjectAreaGUIDs) + ", associatedGovernanceDefinitions=" + String.valueOf(this.associatedGovernanceDefinitions) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof SubjectAreaElement)) {
            return false;
        }
        SubjectAreaElement that = (SubjectAreaElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.properties, that.properties) && Objects.equals(this.parentSubjectAreaGUID, that.parentSubjectAreaGUID) && Objects.equals(this.nestedSubjectAreaGUIDs, that.nestedSubjectAreaGUIDs) && Objects.equals(this.associatedGovernanceDefinitions, that.associatedGovernanceDefinitions);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.properties);
    }
}

