/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.TeamProfileProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TeamProfileElement
implements MetadataElement {
    private ElementHeader elementHeader = null;
    private TeamProfileProperties properties = null;
    private ElementStub superTeam = null;
    private List<ElementStub> subTeams = null;

    public TeamProfileElement() {
    }

    public TeamProfileElement(TeamProfileElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.properties = template.getProperties();
            this.superTeam = template.getSuperTeam();
            this.subTeams = template.getSubTeams();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public TeamProfileProperties getProperties() {
        return this.properties;
    }

    public void setProperties(TeamProfileProperties properties) {
        this.properties = properties;
    }

    public ElementStub getSuperTeam() {
        return this.superTeam;
    }

    public void setSuperTeam(ElementStub superTeam) {
        this.superTeam = superTeam;
    }

    public List<ElementStub> getSubTeams() {
        if (this.subTeams == null) {
            return null;
        }
        if (this.subTeams.isEmpty()) {
            return null;
        }
        return new ArrayList<ElementStub>(this.subTeams);
    }

    public void setSubTeams(List<ElementStub> subTeams) {
        this.subTeams = subTeams;
    }

    public String toString() {
        return "TeamProfileElement{elementHeader=" + String.valueOf(this.elementHeader) + ", properties=" + String.valueOf(this.properties) + ", superTeam='" + String.valueOf(this.superTeam) + "', subTeams=" + String.valueOf(this.subTeams) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        TeamProfileElement that = (TeamProfileElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.properties, that.properties) && Objects.equals(this.superTeam, that.superTeam) && Objects.equals(this.subTeams, that.subTeams);
    }

    public int hashCode() {
        return Objects.hash(this.elementHeader, this.properties, this.superTeam, this.subTeams);
    }
}

