/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MetadataCorrelationProperties
extends ExternalIdentifierProperties {
    private String externalScopeGUID = null;
    private String externalScopeName = null;
    private String externalScopeTypeName;

    public MetadataCorrelationProperties() {
        this.externalScopeTypeName = OpenMetadataType.INVENTORY_CATALOG.typeName;
    }

    public MetadataCorrelationProperties(MetadataCorrelationProperties template) {
        super(template);
        this.externalScopeTypeName = OpenMetadataType.INVENTORY_CATALOG.typeName;
        if (template != null) {
            this.externalScopeGUID = template.getExternalScopeGUID();
            this.externalScopeName = template.getExternalScopeName();
            this.externalScopeTypeName = template.getExternalScopeTypeName();
        }
    }

    public MetadataCorrelationProperties(ExternalIdentifierProperties template) {
        super(template);
        this.externalScopeTypeName = OpenMetadataType.INVENTORY_CATALOG.typeName;
    }

    public String getExternalScopeGUID() {
        return this.externalScopeGUID;
    }

    public void setExternalScopeGUID(String externalScopeGUID) {
        this.externalScopeGUID = externalScopeGUID;
    }

    public String getExternalScopeName() {
        return this.externalScopeName;
    }

    public void setExternalScopeName(String externalScopeName) {
        this.externalScopeName = externalScopeName;
    }

    public String getExternalScopeTypeName() {
        return this.externalScopeTypeName;
    }

    public void setExternalScopeTypeName(String externalScopeTypeName) {
        this.externalScopeTypeName = externalScopeTypeName;
    }

    @Override
    public String toString() {
        return "MetadataCorrelationProperties{externalScopeGUID='" + this.externalScopeGUID + "', externalScopeName='" + this.externalScopeName + "', externalScopeTypeName='" + this.externalScopeTypeName + "', synchronizationDirection=" + String.valueOf(this.getSynchronizationDirection()) + ", synchronizationDescription='" + this.getSynchronizationDescription() + "', externalIdentifier='" + this.getExternalIdentifier() + "', externalIdentifierName='" + this.getExternalIdentifierName() + "', externalIdentifierUsage='" + this.getExternalIdentifierUsage() + "', externalIdentifierSource='" + this.getExternalIdentifierSource() + "', keyPattern=" + String.valueOf(this.getKeyPattern()) + ", externalInstanceCreatedBy='" + this.getExternalInstanceCreatedBy() + "', externalInstanceCreationTime=" + String.valueOf(this.getExternalInstanceCreationTime()) + ", externalInstanceLastUpdatedBy='" + this.getExternalInstanceLastUpdatedBy() + "', externalInstanceLastUpdateTime=" + String.valueOf(this.getExternalInstanceLastUpdateTime()) + ", externalInstanceVersion=" + this.getExternalInstanceVersion() + ", mappingProperties=" + String.valueOf(this.getMappingProperties()) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        MetadataCorrelationProperties that = (MetadataCorrelationProperties)objectToCompare;
        return Objects.equals(this.externalScopeGUID, that.externalScopeGUID) && Objects.equals(this.externalScopeName, that.externalScopeName) && Objects.equals(this.externalScopeTypeName, that.externalScopeTypeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.externalScopeGUID, this.externalScopeName, this.externalScopeTypeName);
    }
}

