/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataClassificationPropagationRule;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationshipEndDef;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataTypeDef;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataTypeDefCategory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenMetadataRelationshipDef
extends OpenMetadataTypeDef {
    private OpenMetadataClassificationPropagationRule propagationRule = OpenMetadataClassificationPropagationRule.NONE;
    private OpenMetadataRelationshipEndDef endDef1 = null;
    private OpenMetadataRelationshipEndDef endDef2 = null;
    private boolean multiLink = false;

    public OpenMetadataRelationshipDef() {
        super(OpenMetadataTypeDefCategory.RELATIONSHIP_DEF);
    }

    public OpenMetadataRelationshipDef(OpenMetadataTypeDefCategory category, String guid, String name, long version, String versionName) {
        super(category, guid, name, version, versionName);
    }

    public OpenMetadataRelationshipDef(OpenMetadataRelationshipDef templateTypeDef) {
        super(templateTypeDef);
        if (templateTypeDef != null) {
            this.propagationRule = templateTypeDef.getPropagationRule();
            this.endDef1 = templateTypeDef.getEndDef1();
            this.endDef2 = templateTypeDef.getEndDef2();
            this.multiLink = templateTypeDef.getMultiLink();
        }
    }

    @Override
    public OpenMetadataTypeDef cloneFromSubclass() {
        return new OpenMetadataRelationshipDef(this);
    }

    public OpenMetadataClassificationPropagationRule getPropagationRule() {
        return this.propagationRule;
    }

    public void setPropagationRule(OpenMetadataClassificationPropagationRule propagationRule) {
        this.propagationRule = propagationRule;
    }

    public OpenMetadataRelationshipEndDef getEndDef1() {
        if (this.endDef1 == null) {
            return null;
        }
        return new OpenMetadataRelationshipEndDef(this.endDef1);
    }

    public void setEndDef1(OpenMetadataRelationshipEndDef endDef1) {
        this.endDef1 = endDef1;
    }

    public OpenMetadataRelationshipEndDef getEndDef2() {
        if (this.endDef2 == null) {
            return null;
        }
        return new OpenMetadataRelationshipEndDef(this.endDef2);
    }

    public void setEndDef2(OpenMetadataRelationshipEndDef endDef2) {
        this.endDef2 = endDef2;
    }

    public boolean getMultiLink() {
        return this.multiLink;
    }

    public void setMultiLink(boolean multiLink) {
        this.multiLink = multiLink;
    }

    @Override
    public String toString() {
        return "OpenMetadataRelationshipDef{name='" + this.getName() + "', description='" + this.getDescription() + "', endDef1=" + String.valueOf(this.endDef1) + ", endDef2=" + String.valueOf(this.endDef2) + ", multiLink=" + this.multiLink + ", superType=" + String.valueOf(this.getSuperType()) + ", descriptionGUID='" + this.getDescriptionGUID() + "', descriptionWiki='" + this.getDescriptionWiki() + "', origin='" + this.getOrigin() + "', createdBy='" + this.getCreatedBy() + "', updatedBy='" + this.getUpdatedBy() + "', createTime=" + String.valueOf(this.getCreateTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", options=" + String.valueOf(this.getOptions()) + ", externalStandardTypeMappings=" + String.valueOf(this.getExternalStandardMappings()) + ", validInstanceStatusList=" + String.valueOf(this.getValidElementStatusList()) + ", initialStatus=" + String.valueOf(this.getInitialStatus()) + ", propertiesDefinition=" + String.valueOf(this.getAttributeDefinitions()) + ", category=" + String.valueOf((Object)this.getCategory()) + ", propagationRule=" + String.valueOf((Object)this.propagationRule) + ", version=" + this.getVersion() + ", versionName='" + this.getVersionName() + "', GUID='" + this.getGUID() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OpenMetadataRelationshipDef that = (OpenMetadataRelationshipDef)objectToCompare;
        return this.multiLink == that.multiLink && this.propagationRule == that.propagationRule && Objects.equals(this.endDef1, that.endDef1) && Objects.equals(this.endDef2, that.endDef2);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.propagationRule, this.endDef1, this.endDef2, this.multiLink});
    }
}

