/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RelatedMetadataElement
extends ElementControlHeader {
    private String relationshipGUID = null;
    private Date effectiveFromTime = null;
    private Date effectiveToTime = null;
    private ElementProperties relationshipProperties = null;
    private OpenMetadataElement element = null;
    private boolean elementAtEnd1 = false;

    public RelatedMetadataElement() {
    }

    public RelatedMetadataElement(RelatedMetadataElement template) {
        super(template);
        if (template != null) {
            this.relationshipGUID = template.getRelationshipGUID();
            this.effectiveFromTime = template.getEffectiveFromTime();
            this.effectiveToTime = template.getEffectiveToTime();
            this.relationshipProperties = template.getRelationshipProperties();
            this.element = template.getElement();
            this.elementAtEnd1 = template.getElementAtEnd1();
        }
    }

    public String getRelationshipGUID() {
        return this.relationshipGUID;
    }

    public void setRelationshipGUID(String guid) {
        this.relationshipGUID = guid;
    }

    public Date getEffectiveFromTime() {
        return this.effectiveFromTime;
    }

    public void setEffectiveFromTime(Date effectiveFromTime) {
        this.effectiveFromTime = effectiveFromTime;
    }

    public Date getEffectiveToTime() {
        return this.effectiveToTime;
    }

    public void setEffectiveToTime(Date effectiveToTime) {
        this.effectiveToTime = effectiveToTime;
    }

    public ElementProperties getRelationshipProperties() {
        return this.relationshipProperties;
    }

    public void setRelationshipProperties(ElementProperties relationshipProperties) {
        this.relationshipProperties = relationshipProperties;
    }

    public OpenMetadataElement getElement() {
        return this.element;
    }

    public void setElement(OpenMetadataElement element) {
        this.element = element;
    }

    public boolean getElementAtEnd1() {
        return this.elementAtEnd1;
    }

    public void setElementAtEnd1(boolean elementAtEnd1) {
        this.elementAtEnd1 = elementAtEnd1;
    }

    @Override
    public String toString() {
        return "RelatedMetadataElement{relationshipGUID='" + this.relationshipGUID + "', effectiveFromTime=" + String.valueOf(this.effectiveFromTime) + ", effectiveToTime=" + String.valueOf(this.effectiveToTime) + ", relationshipProperties=" + String.valueOf(this.relationshipProperties) + ", element=" + String.valueOf(this.element) + ", elementAtEnd1=" + this.elementAtEnd1 + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RelatedMetadataElement that = (RelatedMetadataElement)objectToCompare;
        return Objects.equals(this.relationshipGUID, that.relationshipGUID) && Objects.equals(this.effectiveFromTime, that.effectiveFromTime) && Objects.equals(this.effectiveToTime, that.effectiveToTime) && Objects.equals(this.relationshipProperties, that.relationshipProperties) && Objects.equals(this.element, that.element) && this.elementAtEnd1 == that.elementAtEnd1;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relationshipGUID, this.effectiveFromTime, this.effectiveToTime, this.relationshipProperties, this.element, this.elementAtEnd1);
    }
}

